package com.rocogz.syy.common.web.converter;

import org.apache.commons.lang3.time.DateUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

import javax.validation.ValidationException;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

/**
 * @author zhangmin
 * @date 2020/4/12
 */
public class LocalDateTimeConverter implements Converter<String,LocalDateTime> {

    String[] dateTimePatterns = {"yyyy-MM-dd HH:mm:ss","yyyy/MM/dd HH:mm:ss",
                                 "yyyy-MM-dd HH:mm","yyyy/MM/dd HH:mm",
                                 "yyyy年MM月dd日 HH:mm:ss","yyyy年MM月dd日 HH:mm"};
    @Override
    public LocalDateTime convert(String source) {
        if(StringUtils.isEmpty(source)) {
            return null;
        }

        try {
            Date date = DateUtils.parseDate(source,dateTimePatterns);
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()),ZoneId.systemDefault());
        } catch (ParseException ex) {
            throw new ValidationException("日期时间格式不正确，输入的日期时间是：" + source);
        }
    }


}
