/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.tencent.resp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.rocogz.syy.common.tencent.DistanceTime;
import com.rocogz.syy.common.tencent.LngLat;
import com.rocogz.syy.common.tencent.resp.QQMapBaseResp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class QQMultiOriginMultiDestDistanceResp
extends QQMapBaseResp {
    private MultiOriginDistance result;

    public MultiOriginDistance getResult() {
        return this.result;
    }

    public void setResult(MultiOriginDistance result) {
        this.result = result;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class OneOriginDistance {
        private LngLat origin;
        @JsonProperty(value="elements")
        private List<DistanceTime> distanceList;

        public LngLat getOrigin() {
            return this.origin;
        }

        public void setOrigin(LngLat origin) {
            this.origin = origin;
        }

        public List<DistanceTime> getDistanceList() {
            return this.distanceList;
        }

        public void setDistanceList(List<DistanceTime> distanceList) {
            this.distanceList = distanceList;
        }

        public void sortByDistance(Sort.Direction sortDirect) {
            if (CollectionUtils.isEmpty(this.distanceList) || sortDirect == null) {
                return;
            }
            Collections.sort(this.distanceList, (d1, d2) -> {
                if (sortDirect.isAscending()) {
                    return d1.getDistance() - d2.getDistance();
                }
                return d1.getDistance() - d1.getDistance();
            });
        }
    }

    public static class MultiOriginDistance {
        @JsonProperty(value="rows")
        private List<OneOriginDistance> originDistanceList;

        public List<OneOriginDistance> getOriginDistanceList() {
            return this.originDistanceList;
        }

        public void setOriginDistanceList(List<OneOriginDistance> originDistanceList) {
            this.originDistanceList = originDistanceList;
        }

        public void addOriginDistance(OneOriginDistance orginDist) {
            if (orginDist == null) {
                return;
            }
            if (this.originDistanceList == null) {
                this.originDistanceList = new ArrayList<OneOriginDistance>();
            }
            this.originDistanceList.add(orginDist);
        }
    }
}

