/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.web.converter;

import java.time.YearMonth;
import java.time.format.DateTimeParseException;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

public class YearMonthConverter
implements Converter<String, YearMonth> {
    public YearMonth convert(String source) {
        if (StringUtils.isEmpty((CharSequence)source) || source.length() != 7 && source.length() != 8) {
            return null;
        }
        return this.doConvert(source);
    }

    private YearMonth doConvert(String inputYearMonth) {
        if (inputYearMonth.length() == 7) {
            inputYearMonth = inputYearMonth.replace("/", "-");
        } else {
            inputYearMonth = inputYearMonth.replace("\u5e74", "-");
            inputYearMonth = inputYearMonth.replace("\u6708", "");
        }
        try {
            return YearMonth.parse(inputYearMonth);
        }
        catch (DateTimeParseException ex) {
            throw new ValidationException("\u5e74\u6708\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8f93\u5165\u7684yearMonth\u662f\uff1a" + inputYearMonth);
        }
    }
}

