/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.methodaoplog;

import com.rocogz.syy.common.methodaoplog.RequestLog;
import com.rocogz.syy.common.web.JsonJava8Util;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
@Aspect
public class MethodAopLog {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="@annotation(com.rocogz.syy.common.methodaoplog.RequestLog)")
    public void pointcutMethod() {
    }

    @Around(value="pointcutMethod() && @annotation(requestLog)", argNames="requestLog")
    public Object around(ProceedingJoinPoint point, RequestLog requestLog) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object object = null;
        String argsArr = "";
        String resJson = "";
        String err = "";
        long endTime = 0L;
        try {
            Object[] args = point.getArgs();
            if (ArrayUtils.isNotEmpty((Object[])args)) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < args.length; ++i) {
                    sb.append(i).append(":").append(JsonJava8Util.toJson(args[i]));
                }
                argsArr = sb.toString();
            }
            object = point.proceed();
        }
        catch (Throwable throwable) {
            endTime = System.currentTimeMillis();
            err = throwable.getMessage();
            this.log.error("MethodAopLog\u62e6\u622a\u5230\u7684\u5f02\u5e38 -> module: {} apiUrl: {} Args:{} startTime: {}, endTime: {}, use: {}ms error: {} ", new Object[]{requestLog.module(), requestLog.apiUrl(), argsArr, startTime, endTime, endTime - startTime, err, throwable});
            throw throwable;
        }
        resJson = JsonJava8Util.toJson(object);
        endTime = System.currentTimeMillis();
        if (RequestLog.Level.INFO.name().equals(requestLog.level().name())) {
            this.log.info("module: {} apiUrl: {} Args:{} res: {} startTime: {}, endTime: {}, use: {}ms error: {}", new Object[]{requestLog.module(), requestLog.apiUrl(), argsArr, resJson, startTime, endTime, endTime - startTime, err});
        } else if (RequestLog.Level.DEBUG.name().equals(requestLog.level().name())) {
            this.log.debug("module: {} apiUrl: {} Args:{} res: {} startTime: {}, endTime: {}, use: {}ms error: {}", new Object[]{requestLog.module(), requestLog.apiUrl(), argsArr, resJson, startTime, endTime, endTime - startTime, err});
        }
        return object;
    }
}

