/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.basicserialno.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.rocogz.redis.RedisService;
import com.rocogz.syy.common.basicserialno.entity.BasicSerialNo;
import com.rocogz.syy.common.basicserialno.mapper.BasicSerialNoMapper;
import com.rocogz.syy.common.basicserialno.service.SerialNoRuleEnum;
import com.rocogz.syy.common.web.JsonJava8Util;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component
@MapperScan(value={"com.rocogz.syy.common"})
public class SerialNoService
extends ServiceImpl<BasicSerialNoMapper, BasicSerialNo>
implements IService<BasicSerialNo> {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private RedisService redisService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private static final String FLAG_PREFIX = "GENERATE_NO:SYY";
    private static final int CAPACITY_THRESHOLD = 500;
    private static final Long BATCH_SIZE = 1000L;
    private static final int RETRY_LIMIT = 3;
    private static final long RETRY_TIME = 3000L;

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public String generateCode(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new RuntimeException("\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int retryNum = 0;
        BasicSerialNo cacheSerialNo = this.getCacheAvailableSerialNo(type, retryNum);
        Assert.notNull((Object)cacheSerialNo, (String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u5e8f\u53f7");
        String seqKey = this.getRedisKey(type, RedisKey.CUR_SEQ_NO_PREFIX);
        Long seqNo = this.redisService.incr(seqKey);
        this.checkSeq(seqNo, cacheSerialNo, type);
        this.checkCapacity(seqNo, cacheSerialNo, type);
        return this.aggregateResult(seqNo, cacheSerialNo);
    }

    private String aggregateResult(Long seqNo, BasicSerialNo cacheSerialNo) {
        StringBuilder result = new StringBuilder();
        result.append(cacheSerialNo.getSeqPrefix());
        result.append(this.formatPattern(cacheSerialNo.getLastestDate(), cacheSerialNo.getFormatPattern()));
        result.append(StringUtils.leftPad((String)seqNo.toString(), (int)cacheSerialNo.getSeqLpadLength(), (String)"0"));
        String resultStr = result.toString();
        this.log.info("generateCode:{}", (Object)resultStr);
        return resultStr;
    }

    private String formatPattern(LocalDate localDate, String pattern) {
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            if (Objects.isNull(localDate)) {
                localDate = LocalDate.now();
            }
            return pattern.replace("%Y", String.valueOf(localDate.getYear())).replace("%m", StringUtils.leftPad((String)String.valueOf(localDate.getMonthValue()), (int)2, (String)"0")).replace("%d", StringUtils.leftPad((String)String.valueOf(localDate.getDayOfMonth()), (int)2, (String)"0"));
        }
        return "";
    }

    private void checkCapacity(Long seqNo, BasicSerialNo cacheSerialNo, String type) {
        long size = cacheSerialNo.getSeqNo() - seqNo;
        this.log.info("[{}]:\u7f13\u5b58\u4e0a\u9650:[{}],\u5269\u4f59\u6570:[{}]", new Object[]{type, cacheSerialNo.getSeqNo(), size});
        if (size < 500L) {
            BasicSerialNo BasicSerialNo2 = (BasicSerialNo)this.getById((Serializable)((Object)type));
            Assert.notNull((Object)BasicSerialNo2, (String)("\u83b7\u53d6\u5e8f\u53f7\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u914d\u7f6e\uff1a" + type));
            this.capacitySerialNo(BasicSerialNo2, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicSerialNo capacitySerialNo(final BasicSerialNo BasicSerialNo2, final String type) {
        String lockKey = this.getRedisKey(type, RedisKey.CAPACITY_SEQ_NO_PREFIX);
        boolean tryLock = this.redisService.lockByNXPX(lockKey, 1500L);
        if (tryLock) {
            this.log.info("\u5f00\u59cb\u6269\u5bb9");
            try {
                final Long oilVersion = BasicSerialNo2.getVersion();
                final Long originSeqNo = BasicSerialNo2.getSeqNo() == null ? 0L : BasicSerialNo2.getSeqNo();
                final Long newSeqNo = originSeqNo + BATCH_SIZE;
                final String seqVal = this.aggregateResult(newSeqNo, BasicSerialNo2);
                BasicSerialNo updateNo = new BasicSerialNo();
                updateNo.setSeqNo(newSeqNo);
                updateNo.setSeqVal(seqVal);
                updateNo.setVersion(oilVersion + 1L);
                updateNo.setLastestDate(LocalDate.now());
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"SEQ_CODE", (Object)type);
                updateWrapper.eq((Object)"version", (Object)oilVersion);
                boolean result = this.update(updateNo, (Wrapper)updateWrapper);
                if (result) {
                    this.redisTemplate.executePipelined((RedisCallback)new RedisCallback<Object>(){

                        public Object doInRedis(RedisConnection connection) throws DataAccessException {
                            byte[] noKey = SerialNoService.this.getRedisKey(type, RedisKey.CUR_SEQ_NO_PREFIX).getBytes();
                            byte[] noVal = originSeqNo.toString().getBytes();
                            connection.setNX(noKey, noVal);
                            BasicSerialNo2.setSeqNo(newSeqNo);
                            BasicSerialNo2.setSeqVal(seqVal);
                            BasicSerialNo2.setVersion(oilVersion + 1L);
                            BasicSerialNo2.setLastestDate(LocalDate.now());
                            SerialNoService.this.setRedisConf(connection, BasicSerialNo2, type);
                            return null;
                        }
                    });
                    this.log.info("[{}]:\u7f13\u5b58\u4e0a\u9650\uff1a[{}], \u6269\u5bb9\u5b8c\u6bd5", (Object)BasicSerialNo2.getSeqCode(), (Object)BasicSerialNo2.getSeqNo());
                    BasicSerialNo basicSerialNo = BasicSerialNo2;
                    return basicSerialNo;
                }
                this.log.error("\u6269\u5bb9\u4fee\u6539\u5e8f\u53f7\u5931\u8d25");
            }
            finally {
                this.redisService.releaseLockByNXPX(lockKey);
            }
        } else {
            this.log.info("\u83b7\u9501\u5931\u8d25\uff0c\u8df3\u8fc7\u6269\u5bb9");
        }
        return null;
    }

    private void checkSeq(Long seq, BasicSerialNo BasicSerialNo2, String type) {
        try {
            Assert.notNull((Object)seq, (String)"\u751f\u6210\u5e8f\u53f7\u4e3anull");
            Assert.isTrue((seq > 0L ? 1 : 0) != 0, (String)"\u751f\u6210\u5e8f\u53f7\u4e3a\u8d1f\u6570");
            Assert.isTrue((seq <= BasicSerialNo2.getSeqNo() ? 1 : 0) != 0, (String)"\u751f\u6210\u5e8f\u53f7\u8d85\u8fc7\u4e0a\u9650");
            Assert.isTrue((seq.toString().length() <= BasicSerialNo2.getSeqLpadLength() ? 1 : 0) != 0, (String)"\u751f\u6210\u5e8f\u53f7\u8d85\u8fc7\u9650\u5236\u957f\u5ea6");
        }
        catch (Exception e) {
            this.clearCacheSerialNo(type);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicSerialNo initSerialNo(String type, int retryNum) {
        this.log.info("\u521d\u59cb\u5316");
        String lockKey = this.getRedisKey(type, RedisKey.INIT_SEQ_NO_PREFIX);
        boolean tryLock = this.redisService.lockByNXPX(lockKey, 15000L);
        if (tryLock) {
            try {
                BasicSerialNo BasicSerialNo2 = (BasicSerialNo)this.getById((Serializable)((Object)type));
                Assert.notNull((Object)BasicSerialNo2, (String)("\u83b7\u53d6\u5e8f\u53f7\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u914d\u7f6e\uff1a" + type));
                BasicSerialNo check = this.checkRestGet(BasicSerialNo2, type, retryNum);
                if (check != null) {
                    BasicSerialNo basicSerialNo = check;
                    return basicSerialNo;
                }
                BasicSerialNo basicSerialNo = this.capacitySerialNo(BasicSerialNo2, type);
                return basicSerialNo;
            }
            finally {
                this.redisService.releaseLockByNXPX(lockKey);
            }
        }
        return this.retry(type, retryNum);
    }

    private void clearCacheSerialNo(String type) {
        String prefixKey = this.getRedisKey(type, RedisKey.SEQ_NO_CONF_PREFIX);
        String noPrefix = this.getRedisKey(type, RedisKey.CUR_SEQ_NO_PREFIX);
        this.redisService.deleteKeys(new String[]{prefixKey, noPrefix});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicSerialNo resetSerialNo(final String type, int retryNum) {
        this.log.info("\u91cd\u7f6e\u5e8f\u53f7");
        String lockKey = this.getRedisKey(type, RedisKey.REST_SEQ_NO_PREFIX);
        boolean tryLock = this.redisService.lockByNXPX(lockKey, 15000L);
        if (tryLock) {
            try {
                final BasicSerialNo BasicSerialNo2 = (BasicSerialNo)this.getById((Serializable)((Object)type));
                Assert.notNull((Object)BasicSerialNo2, (String)("\u83b7\u53d6\u5e8f\u53f7\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u914d\u7f6e\uff1a" + type));
                final Long oilVersion = BasicSerialNo2.getVersion();
                final String seqVal = this.aggregateResult(BATCH_SIZE, BasicSerialNo2);
                BasicSerialNo updateNo = new BasicSerialNo();
                updateNo.setSeqNo(BATCH_SIZE);
                updateNo.setSeqVal(seqVal);
                updateNo.setVersion(oilVersion + 1L);
                updateNo.setLastestDate(LocalDate.now());
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"SEQ_CODE", (Object)type);
                updateWrapper.eq((Object)"version", (Object)oilVersion);
                boolean result = this.update(updateNo, (Wrapper)updateWrapper);
                if (result) {
                    this.redisTemplate.executePipelined((RedisCallback)new RedisCallback<Object>(){

                        public Object doInRedis(RedisConnection connection) throws DataAccessException {
                            byte[] noKey = SerialNoService.this.getRedisKey(type, RedisKey.CUR_SEQ_NO_PREFIX).getBytes();
                            byte[] noVal = "0".getBytes();
                            connection.set(noKey, noVal);
                            BasicSerialNo2.setSeqNo(BATCH_SIZE);
                            BasicSerialNo2.setSeqVal(seqVal);
                            BasicSerialNo2.setVersion(oilVersion + 1L);
                            BasicSerialNo2.setLastestDate(LocalDate.now());
                            SerialNoService.this.setRedisConf(connection, BasicSerialNo2, type);
                            return null;
                        }
                    });
                    BasicSerialNo basicSerialNo = BasicSerialNo2;
                    return basicSerialNo;
                }
                this.log.info("\u91cd\u7f6e\u5e8f\u53f7\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            }
            finally {
                this.redisService.releaseLockByNXPX(lockKey);
            }
        } else {
            return this.retry(type, retryNum);
        }
        return null;
    }

    private void setRedisConf(RedisConnection connection, BasicSerialNo BasicSerialNo2, String type) {
        byte[] conf = JsonJava8Util.toJson(BasicSerialNo2).getBytes();
        Integer expire = this.getExpireSeconds(BasicSerialNo2.getSeqNoResetRule());
        if (expire != null) {
            this.log.info(" rule:{},  expire:{}", (Object)BasicSerialNo2.getSeqNoResetRule(), (Object)expire);
            connection.setEx(this.getRedisKey(type, RedisKey.SEQ_NO_CONF_PREFIX).getBytes(), (long)expire.intValue(), conf);
        } else {
            connection.set(this.getRedisKey(type, RedisKey.SEQ_NO_CONF_PREFIX).getBytes(), conf);
        }
    }

    private Integer getExpireSeconds(String restRuleStr) {
        SerialNoRuleEnum restRule = SerialNoRuleEnum.getByName(restRuleStr);
        if (restRule != null) {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime lastDayTime = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
            LocalDateTime end = null;
            switch (restRule) {
                case DAY: {
                    end = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
                    break;
                }
                case MONTH: {
                    end = lastDayTime.with(TemporalAdjusters.lastDayOfMonth());
                    break;
                }
                case YEAR: {
                    end = lastDayTime.with(TemporalAdjusters.lastDayOfYear());
                    break;
                }
                default: {
                    return null;
                }
            }
            return Integer.valueOf(Duration.between(now, end).toMillis() / 1000L + "");
        }
        return null;
    }

    private BasicSerialNo retry(String type, int retryNum) {
        try {
            this.log.info("\u8fdb\u5165\u4f11\u7720\u7b49\u5f85\u91cd\u8bd5");
            Thread.sleep(3000L);
            if (retryNum < 3) {
                return this.getCacheAvailableSerialNo(type, retryNum);
            }
            this.log.info("\u8d85\u8fc7\u6700\u5927\u91cd\u8bd5\u6b21\u6570");
        }
        catch (InterruptedException e) {
            this.log.error("\u4f11\u7720\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    private BasicSerialNo getCacheAvailableSerialNo(String type, int retryNum) {
        this.log.info("\u7b2c{}\u6b21\u83b7\u53d6\u914d\u7f6e", (Object)(++retryNum));
        String confKey = this.getRedisKey(type, RedisKey.SEQ_NO_CONF_PREFIX);
        String jsonConfStr = this.redisService.get(confKey);
        if (StringUtils.isBlank((CharSequence)jsonConfStr)) {
            return this.initSerialNo(type, retryNum);
        }
        try {
            BasicSerialNo BasicSerialNo2 = JsonJava8Util.fromJson(jsonConfStr, BasicSerialNo.class);
            BasicSerialNo check = this.checkRestGet(BasicSerialNo2, type, retryNum);
            if (check != null) {
                return check;
            }
            return BasicSerialNo2;
        }
        catch (Exception e) {
            this.log.error("\u89e3\u6790\u5e8f\u53f7\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
            this.clearCacheSerialNo(type);
            return this.initSerialNo(type, retryNum);
        }
    }

    private BasicSerialNo checkRestGet(BasicSerialNo BasicSerialNo2, String type, int retryNum) {
        SerialNoRuleEnum resetRule = SerialNoRuleEnum.getByName(BasicSerialNo2.getSeqNoResetRule());
        if (resetRule != null) {
            int nowYear = LocalDate.now().getYear();
            int nowMonth = LocalDate.now().getMonthValue();
            int nowDay = LocalDate.now().getDayOfMonth();
            switch (resetRule) {
                case YEAR: {
                    if (BasicSerialNo2.getLastestDate() != null && nowYear == BasicSerialNo2.getLastestDate().getYear()) break;
                    return this.resetSerialNo(type, retryNum);
                }
                case MONTH: {
                    if (BasicSerialNo2.getLastestDate() != null && nowYear == BasicSerialNo2.getLastestDate().getYear() && nowMonth == BasicSerialNo2.getLastestDate().getMonthValue()) break;
                    return this.resetSerialNo(type, retryNum);
                }
                case DAY: {
                    if (BasicSerialNo2.getLastestDate() != null && nowYear == BasicSerialNo2.getLastestDate().getYear() && nowMonth == BasicSerialNo2.getLastestDate().getMonthValue() && nowDay == BasicSerialNo2.getLastestDate().getDayOfMonth()) break;
                    return this.resetSerialNo(type, retryNum);
                }
                case FOREVER: {
                    break;
                }
                default: {
                    this.log.info("\u9ed8\u8ba4\u4e0d\u91cd\u7f6e");
                }
            }
        }
        return null;
    }

    private String getRedisKey(String type, RedisKey redisKey) {
        return String.join((CharSequence)":", FLAG_PREFIX, redisKey.name(), type);
    }

    static enum RedisKey {
        CUR_SEQ_NO_PREFIX,
        SEQ_NO_CONF_PREFIX,
        INIT_SEQ_NO_PREFIX,
        REST_SEQ_NO_PREFIX,
        CAPACITY_SEQ_NO_PREFIX;

    }
}

