/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.web.converter;

import java.text.ParseException;
import java.time.LocalDate;
import java.util.Date;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.core.convert.converter.Converter;

public class LocalDateConverter
implements Converter<String, LocalDate> {
    String[] datePatterns = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "yyyy\u5e74MM\u6708dd\u65e5"};

    public LocalDate convert(String source) {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return null;
        }
        return this.doConvert(source);
    }

    private LocalDate doConvert(String inputDate) {
        if (inputDate.length() == 8 && StringUtils.isNumeric((CharSequence)inputDate)) {
            String year = inputDate.substring(0, 4);
            String month = inputDate.substring(4, 6);
            String day = inputDate.substring(6, 8);
            inputDate = String.join((CharSequence)"-", year, month, day);
        }
        try {
            Date date = DateUtils.parseDate((String)inputDate, (String[])this.datePatterns);
            return LocalDate.of(1900 + date.getYear(), date.getMonth() + 1, date.getDate());
        }
        catch (ParseException e) {
            throw new ValidationException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8f93\u5165\u7684\u65e5\u671f\u662f\uff1a" + inputDate);
        }
    }
}

