/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.web;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.rocogz.syy.common.web.converter.LocalDateConverter;
import com.rocogz.syy.common.web.converter.LocalDateTimeConverter;
import com.rocogz.syy.common.web.converter.LocalTimeConverter;
import com.rocogz.syy.common.web.converter.YearMonthConverter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnWebApplication
public class JacksonCustomizerConverterAutoConfiguration {
    private static final String dateFormat = "yyyy-MM-dd";
    private static final String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME_FORMAT = "HH:mm:ss";
    public static ObjectMapper OBJECT_MAPPER;

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer jsonCustomizer() {
        return builder -> {
            builder.simpleDateFormat(dateTimeFormat);
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimeFormat);
            builder.modulesToInstall(new Module[]{new Jdk8Module(), new JavaTimeModule(), new ParameterNamesModule()});
            builder.serializers(new JsonSerializer[]{new LocalDateSerializer(DateTimeFormatter.ofPattern(dateFormat))});
            builder.serializers(new JsonSerializer[]{new LocalDateTimeSerializer(dateTimeFormatter)});
            builder.serializers(new JsonSerializer[]{new LocalTimeSerializer(DateTimeFormatter.ofPattern(TIME_FORMAT))});
            DateDeserializers.SqlDateDeserializer sqlDateDeserializer = new DateDeserializers.SqlDateDeserializer(new DateDeserializers.SqlDateDeserializer(), (DateFormat)new SimpleDateFormat(dateFormat), dateFormat);
            builder.deserializers(new JsonDeserializer[]{sqlDateDeserializer});
            builder.deserializers(new JsonDeserializer[]{new LocalDateTimeDeserializer(dateTimeFormatter)});
            builder.failOnUnknownProperties(false);
            builder.failOnEmptyBeans(false);
            builder.timeZone(TimeZone.getTimeZone("GMT+8:00"));
        };
    }

    @Bean
    public WebMvcConfigurer registDateConverterConfigurer(MappingJackson2HttpMessageConverter messageConverter) {
        OBJECT_MAPPER = messageConverter.getObjectMapper();
        return new WebMvcConfigurer(){

            public void addFormatters(FormatterRegistry registry) {
                registry.addConverter((Converter)new LocalDateConverter());
                registry.addConverter((Converter)new YearMonthConverter());
                registry.addConverter((Converter)new LocalTimeConverter());
                registry.addConverter((Converter)new LocalDateTimeConverter());
            }
        };
    }
}

