/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.tencent;

import com.rocogz.syy.common.tencent.DistanceTime;
import com.rocogz.syy.common.tencent.LngLat;
import com.rocogz.syy.common.tencent.resp.QQMapBaseResp;
import com.rocogz.syy.common.tencent.resp.QQMultiOriginMultiDestDistanceResp;
import com.rocogz.syy.common.tencent.resp.QQSingleOriginMultiDestDistanceResp;
import com.rocogz.syy.common.tencent.resp.QQUniqueDistanceResp;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class RocoMapService {
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public QQUniqueDistanceResp getUniqueDistanceBetween(LngLat origin, LngLat destination) {
        Assert.notNull((Object)destination, (String)"\u76ee\u7684\u5730\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3aNULL");
        ArrayList<LngLat> toList = new ArrayList<LngLat>();
        toList.add(destination);
        QQSingleOriginMultiDestDistanceResp tempResult = this.getMultiDistanceBetween(origin, toList);
        if (tempResult == null) {
            return null;
        }
        QQUniqueDistanceResp resp = new QQUniqueDistanceResp();
        this.copyStatusMessage(tempResult, resp);
        if (tempResult.isSuccess()) {
            resp.setResult(tempResult.getResult().get(0));
        }
        return resp;
    }

    public QQSingleOriginMultiDestDistanceResp getMultiDistanceBetween(LngLat origin, List<LngLat> destinationList) {
        Assert.notNull((Object)origin, (String)"\u6e90\u5730\u70b9\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3aNULL");
        Assert.notEmpty(destinationList, (String)"\u76ee\u7684\u5730\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        String redisKey = "geoDistances:" + System.currentTimeMillis();
        GeoOperations geoOpers = this.redisTemplate.opsForGeo();
        String from = "from";
        String to = "to-";
        ArrayList<RedisGeoCommands.GeoLocation> geoList = new ArrayList<RedisGeoCommands.GeoLocation>();
        geoList.add(new RedisGeoCommands.GeoLocation((Object)from, new Point(origin.getLng(), origin.getLat())));
        int length = destinationList.size();
        for (int idx = 0; idx < length; ++idx) {
            LngLat destination = destinationList.get(idx);
            geoList.add(new RedisGeoCommands.GeoLocation((Object)(to + idx), new Point(destination.getLng(), destination.getLat())));
        }
        geoOpers.add((Object)redisKey, geoList);
        ArrayList<DistanceTime> resultList = new ArrayList<DistanceTime>();
        for (int idx = 0; idx < length; ++idx) {
            Distance geoDist = geoOpers.distance((Object)redisKey, (Object)from, (Object)(to + idx), (Metric)RedisGeoCommands.DistanceUnit.METERS);
            DistanceTime disTime = new DistanceTime();
            disTime.setDistance((int)geoDist.getValue());
            disTime.setDest(destinationList.get(idx));
            resultList.add(disTime);
        }
        QQSingleOriginMultiDestDistanceResp resp = new QQSingleOriginMultiDestDistanceResp();
        resp.setStatus(0);
        resp.setResult(resultList);
        this.redisTemplate.delete((Object)redisKey);
        return resp;
    }

    public QQSingleOriginMultiDestDistanceResp getMultiDistanceBetweenOrderBy(LngLat origin, List<LngLat> destinationList, Sort.Direction sortDirect) {
        QQSingleOriginMultiDestDistanceResp resp = this.getMultiDistanceBetween(origin, destinationList);
        if (resp != null && resp.isSuccess()) {
            resp.sortByDistance(sortDirect);
        }
        return resp;
    }

    public QQMultiOriginMultiDestDistanceResp getMultiDistanceBetween(List<LngLat> originList, List<LngLat> destinationList) {
        return this.getMultiDistanceBetweenOrderBy(originList, destinationList, null);
    }

    public QQMultiOriginMultiDestDistanceResp getMultiDistanceBetweenOrderBy(List<LngLat> originList, List<LngLat> destinationList, Sort.Direction sortDirect) {
        Assert.notEmpty(originList, (String)"\u6e90\u5730\u5740\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        QQMultiOriginMultiDestDistanceResp multiDestDistanceResp = new QQMultiOriginMultiDestDistanceResp();
        QQMultiOriginMultiDestDistanceResp.MultiOriginDistance multiOrgiginDist = new QQMultiOriginMultiDestDistanceResp.MultiOriginDistance();
        for (int rowIdx = 0; rowIdx < originList.size(); ++rowIdx) {
            LngLat from = originList.get(rowIdx);
            QQSingleOriginMultiDestDistanceResp thisOrginResp = this.getMultiDistanceBetweenOrderBy(from, destinationList, sortDirect);
            QQMultiOriginMultiDestDistanceResp.OneOriginDistance distanceDto = new QQMultiOriginMultiDestDistanceResp.OneOriginDistance();
            distanceDto.setOrigin(from);
            if (thisOrginResp != null) {
                distanceDto.setDistanceList(thisOrginResp.getResult());
            }
            multiOrgiginDist.addOriginDistance(distanceDto);
        }
        multiDestDistanceResp.setStatus(0);
        multiDestDistanceResp.setResult(multiOrgiginDist);
        return multiDestDistanceResp;
    }

    private void copyStatusMessage(QQMapBaseResp from, QQMapBaseResp target) {
        target.setStatus(from.getStatus());
        target.setMessage(from.getMessage());
    }
}

