package com.rocogz.syy.common.tencent.config;

import com.rocogz.syy.common.tencent.RocoMapService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * roco实现的地图计算服务 自动配置类
 * @author zhangmin
 * @date 2020/4/8
 */
@Configuration
@ConditionalOnWebApplication
@ConditionalOnBean(RedisTemplate.class)
@AutoConfigureAfter({WebMvcAutoConfiguration.class,RedisAutoConfiguration.class})
public class RocoMapAutoConfiguration {

    @Bean
    public RocoMapService rocoMapService() {
        return new RocoMapService();
    }

}
