package com.rocogz.syy.common.tencent.resp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 *根据地址信息查询 经纬度坐标 返回结果
 *
 * @author 张敏
 * @创建时间 2020-04-09 17:13
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class QQLngLatResp extends QQMapBaseResp {

    private LngLatResult result;

    public LngLatResult getResult() {
        return result;
    }

    public void setResult(LngLatResult result) {
        this.result = result;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class LngLatResult extends LngLatDistrict {

        @Override
        @JsonProperty("title")
        public void setAddress(String address) {
            this.address = address;
        }
    }

}
