package com.rocogz.syy.common.web.converter;


import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

import javax.validation.ValidationException;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.Date;

/**
 * 支持的格式：yyyy-MM-dd,yyyy-MM-dd,yyyy年mm月dd日 ,或者 yyyyMMdd
 * @author zhangmin
 * @date 2020/4/12
 */
public class LocalDateConverter implements Converter<String,LocalDate> {

    String[] datePatterns = {"yyyy-MM-dd","yyyy/MM/dd","yyyy年MM月dd日"};

    @Override
    public LocalDate convert(String source) {
        if(StringUtils.isEmpty(source)) {
            return null;
        }

        return doConvert(source);
    }


    private LocalDate doConvert(String inputDate) {

        if(inputDate.length() == 8 && StringUtils.isNumeric(inputDate)) {
            //如果是 yyyyMMdd 格式
           String year  = inputDate.substring(0,4);
           String month = inputDate.substring(4,6);
           String day = inputDate.substring(6,8);
           inputDate = String.join("-",year,month,day);
        }

        try {
            Date date = DateUtils.parseDate(inputDate,datePatterns);
            return LocalDate.of(1900+date.getYear(),date.getMonth()+1,date.getDate());
        } catch (ParseException e) {
            throw new ValidationException("日期格式不正确，输入的日期是：" + inputDate);
        }
    }
}
