package com.rocogz.syy.common.web.converter;


import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

import javax.validation.ValidationException;
import java.time.YearMonth;
import java.time.format.DateTimeParseException;


/**
 * 支持的格式：yyyy-MM ,yyyy/MM, yyyy年MM日
 * @author zhangmin
 * @date 2020/4/12
 */
public class YearMonthConverter implements Converter<String,YearMonth> {

    @Override
    public YearMonth convert(String source) {
        if(StringUtils.isEmpty(source) || (source.length()!=7 && source.length()!=8)) {
            return null;
        }

        return doConvert(source);
    }


    private YearMonth doConvert(String inputYearMonth) {
        if(inputYearMonth.length() == 7) {
            inputYearMonth = inputYearMonth.replace("/","-");
        }else {
            //处理 yyyy年MM月 格式
            inputYearMonth = inputYearMonth.replace("年","-");
            inputYearMonth = inputYearMonth.replace("月","");
        }
        try {
            return YearMonth.parse(inputYearMonth);
        } catch (DateTimeParseException ex) {
            throw new ValidationException("年月格式不正确，输入的yearMonth是：" + inputYearMonth);
        }
    }
}
