/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.tencent;

import com.rocogz.syy.common.tencent.DistanceCalcModeEnum;
import com.rocogz.syy.common.tencent.DistanceTime;
import com.rocogz.syy.common.tencent.LngLat;
import com.rocogz.syy.common.tencent.config.QQMapProperties;
import com.rocogz.syy.common.tencent.resp.QQLngLatResp;
import com.rocogz.syy.common.tencent.resp.QQLocationResp;
import com.rocogz.syy.common.tencent.resp.QQMapBaseResp;
import com.rocogz.syy.common.tencent.resp.QQMultiOriginMultiDestDistanceResp;
import com.rocogz.syy.common.tencent.resp.QQSingleOriginMultiDestDistanceResp;
import com.rocogz.syy.common.tencent.resp.QQUniqueDistanceResp;
import com.rocogz.syy.common.web.JsonJava8Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class QQMapService {
    private static final Logger log = LoggerFactory.getLogger(QQMapService.class);
    static final String QQ_MAP_API_DOMAIN = "https://apis.map.qq.com";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ThreadPoolTaskExecutor executorService;
    private QQMapProperties props;

    public QQMapService(QQMapProperties props) {
        this.props = props;
    }

    public QQLngLatResp getLngAndLatByAddress(String address) {
        Assert.hasText((String)address, (String)"address\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        String apiPath = "/ws/geocoder/v1";
        LinkedHashMap<String, String> reqParamMap = new LinkedHashMap<String, String>();
        reqParamMap.put("address", address);
        reqParamMap.put("key", this.props.getKey());
        String sign = this.calcSign(apiPath, reqParamMap);
        String geoUrl = QQ_MAP_API_DOMAIN + apiPath + "/?" + this.joinParams(reqParamMap, true) + "&sig=" + sign;
        QQLngLatResp resp = this.doGetForObject(geoUrl, QQLngLatResp.class);
        return resp;
    }

    public QQLocationResp getLocation(LngLat lngLat) {
        Assert.notNull((Object)lngLat, (String)"\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3aNULL");
        return this.getLocation(lngLat.toLatLngString());
    }

    public QQLocationResp getLocation(String latLng) {
        Assert.hasText((String)latLng, (String)"\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        String apiPath = "/ws/geocoder/v1";
        LinkedHashMap<String, String> reqParamMap = new LinkedHashMap<String, String>();
        reqParamMap.put("location", latLng);
        reqParamMap.put("key", this.props.getKey());
        reqParamMap.put("get_poi", "1");
        String sign = this.calcSign(apiPath, reqParamMap);
        String queryLocationUrl = QQ_MAP_API_DOMAIN + apiPath + "/?" + this.joinParams(reqParamMap, true) + "&sig=" + sign;
        QQLocationResp location = this.doGetForObject(queryLocationUrl, QQLocationResp.class);
        return location;
    }

    public QQUniqueDistanceResp getUniqueDistanceBetween(LngLat origin, LngLat destination) {
        Assert.notNull((Object)destination, (String)"\u76ee\u7684\u5730\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3aNULL");
        ArrayList<LngLat> to = new ArrayList<LngLat>();
        to.add(destination);
        QQSingleOriginMultiDestDistanceResp tempResult = this.getMultiDistanceBetween(origin, to);
        if (tempResult == null) {
            return null;
        }
        QQUniqueDistanceResp resp = new QQUniqueDistanceResp();
        this.copyStatusMessage(tempResult, resp);
        if (tempResult.isSuccess()) {
            resp.setResult(tempResult.getResult().get(0));
        } else {
            log.error("\u83b7\u53d6\u8ddd\u79bb\u5931\u8d25:{}", (Object)JsonJava8Util.toJson(tempResult));
            resp.setResult(this.getZeroDistanceTime(destination));
        }
        return resp;
    }

    public QQSingleOriginMultiDestDistanceResp getMultiDistanceBetween(LngLat origin, List<LngLat> destinationList) {
        Assert.notNull((Object)origin, (String)"\u6e90\u5730\u70b9\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3aNULL");
        ArrayList<LngLat> from = new ArrayList<LngLat>();
        from.add(origin);
        QQMultiOriginMultiDestDistanceResp tempResult = this.getMultiDistanceBetween(from, destinationList);
        if (tempResult == null) {
            return null;
        }
        QQSingleOriginMultiDestDistanceResp resp = new QQSingleOriginMultiDestDistanceResp();
        this.copyStatusMessage(tempResult, resp);
        if (tempResult.isSuccess()) {
            resp.setResult(tempResult.getResult().getOriginDistanceList().get(0).getDistanceList());
        } else {
            log.error("\u83b7\u53d6\u8ddd\u79bb\u5931\u8d25:{}", (Object)JsonJava8Util.toJson(tempResult));
            ArrayList<DistanceTime> defaultDisList = new ArrayList<DistanceTime>();
            for (LngLat dest : destinationList) {
                defaultDisList.add(this.getZeroDistanceTime(dest));
            }
            resp.setResult(defaultDisList);
        }
        return resp;
    }

    public QQSingleOriginMultiDestDistanceResp getMultiDistanceBetweenOrderBy(LngLat origin, List<LngLat> destinationList, Sort.Direction sortDirect) {
        QQSingleOriginMultiDestDistanceResp resp = this.getMultiDistanceBetween(origin, destinationList);
        if (resp != null && resp.isSuccess()) {
            resp.sortByDistance(sortDirect);
        }
        return resp;
    }

    public QQMultiOriginMultiDestDistanceResp getMultiDistanceBetween(List<LngLat> originList, List<LngLat> destinationList) {
        return this.getMultiDistanceBetweenOrderBy(originList, destinationList, null);
    }

    public QQMultiOriginMultiDestDistanceResp getMultiDistanceBetweenOrderBy(List<LngLat> originList, List<LngLat> destinationList, Sort.Direction sortDirect) {
        Assert.notEmpty(originList, (String)"\u6e90\u5730\u5740\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(destinationList, (String)"\u76ee\u7684\u5730\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        String delimiter = ";";
        String from = originList.stream().map(LngLat::toLatLngString).collect(Collectors.joining(";"));
        String to = destinationList.stream().map(LngLat::toLatLngString).collect(Collectors.joining(";"));
        String apiPath = "/ws/distance/v1/matrix";
        LinkedHashMap<String, String> reqParamMap = new LinkedHashMap<String, String>();
        reqParamMap.put("mode", DistanceCalcModeEnum.driving.name());
        reqParamMap.put("from", from);
        reqParamMap.put("to", to);
        reqParamMap.put("key", this.props.getKey());
        String sign = this.calcSign(apiPath, reqParamMap);
        String url = QQ_MAP_API_DOMAIN + apiPath + "/?" + this.joinParams(reqParamMap, true) + "&sig=" + sign;
        QQMultiOriginMultiDestDistanceResp resp = this.doGetForObject(url, QQMultiOriginMultiDestDistanceResp.class);
        if (resp != null && resp.isSuccess()) {
            int rowCount = originList.size();
            int columnCount = destinationList.size();
            for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
                QQMultiOriginMultiDestDistanceResp.OneOriginDistance distanceDto = resp.getResult().getOriginDistanceList().get(rowIdx);
                distanceDto.setOrigin(originList.get(rowIdx));
                for (int colIdx = 0; colIdx < columnCount; ++colIdx) {
                    distanceDto.getDistanceList().get(colIdx).setDest(destinationList.get(colIdx));
                }
                distanceDto.sortByDistance(sortDirect);
            }
        }
        return resp;
    }

    private <T> T doGetForObject(String url, Class<T> respClass) {
        CompletionStage resultFuture = CompletableFuture.supplyAsync(() -> this.restTemplate.getForObject(url, respClass, new Object[0]), (Executor)this.executorService).handle((resp, ex) -> {
            if (ex != null) {
                ex.printStackTrace();
            }
            return resp;
        });
        return ((CompletableFuture)resultFuture).join();
    }

    private void copyStatusMessage(QQMapBaseResp from, QQMapBaseResp target) {
        target.setStatus(from.getStatus());
        target.setMessage(from.getMessage());
    }

    private String joinParams(Map<String, String> reqParamMap, Boolean urlEncoding) {
        if (reqParamMap.isEmpty()) {
            return "";
        }
        ArrayList<String> paramNameList = new ArrayList<String>(reqParamMap.keySet());
        Collections.sort(paramNameList);
        StringBuilder paramPairBuf = new StringBuilder();
        int paramCount = paramNameList.size();
        for (int i = 0; i < paramCount; ++i) {
            String paramName = (String)paramNameList.get(i);
            paramPairBuf.append(paramName).append("=").append(reqParamMap.get(paramName));
            if (i >= paramCount - 1) continue;
            paramPairBuf.append("&");
        }
        return paramPairBuf.toString();
    }

    private String calcSign(String apiPath, Map<String, String> reqParamMap) {
        if (!this.props.isValidSign()) {
            return "";
        }
        String reqParams = this.joinParams(reqParamMap, false);
        String toSignStr = apiPath + "?" + reqParams + this.props.getSk();
        String sign = DigestUtils.md5Hex((String)toSignStr);
        return sign;
    }

    private DistanceTime getZeroDistanceTime(LngLat dest) {
        DistanceTime defaultDis = new DistanceTime();
        defaultDis.setDistance(0);
        defaultDis.setDuration(0);
        defaultDis.setDest(dest);
        return defaultDis;
    }
}

