/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.common.response;

public class Response<T> {
    protected String code;
    protected String message;
    protected T data;

    public Response(String code) {
        this(code, "", null);
    }

    public Response(String code, String message) {
        this(code, message, null);
    }

    public Response(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static Response succeed() {
        return new Response("000000");
    }

    public static Response succeed(String message) {
        return new Response("000000", message);
    }

    public static <E> Response<E> succeed(E data) {
        return new Response<E>("000000", "SUCCEED", data);
    }

    public static <E> Response<E> succeed(String code, E data) {
        return new Response<E>(code, "SUCCEED", data);
    }

    public static Response failure() {
        return new Response("999999");
    }

    public static Response failure(String message) {
        return new Response("999999", message);
    }

    public static Response failure(String code, String message) {
        return new Response(code, message);
    }

    public boolean codeEqual(String targetCode) {
        return targetCode.equals(this.code);
    }

    public boolean isSucceed() {
        return "000000".equals(this.code);
    }

    public String getCode() {
        return this.code;
    }

    public Response setCode(String code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Response setMessage(String message) {
        this.message = message;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public Response setData(T data) {
        this.data = data;
        return this;
    }
}

