package com.rocogz.syy.equity;

/**
 * <dl>
 * <dd>Description: 权益常量类 Service</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-10 17:35:43</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
public final class EquityConstants {

	public static final String EMPTY_MESSAGE = "不能为空";

	/** 数据库字段**/
	public static final String CREATE_TIME_COLUMN = "create_time";

	/** sql日期函数中日期格式**/
	public static final String SQL_DATE_ICON = "'%Y-%m-%d'";

	/** 数据库日期函数大于等于 **/
	public static final String SQL_DATE_FUNCTION_START = "date_format(%s, %s) >= {0}";

	/** 数据库日期函数小于等于 **/
	public static final String SQL_DATE_FUNCTION_END = "date_format(%s, %s) <= {0}";

	/** 批量插入行数 **/
	public static final Integer BATCH_INSERT_ROW = 3000;

	/** 次数的默认值:0（用户券使用次数、重试次数**/
	public static final Integer DEFAULT_QUANTITY_ZERO = 0;

	/** 用户券次数-总次数、可用次数**/
	public static final Integer USER_COUPON_TOTAL_AND_AVAILABLE_QUANTITY = 1;

	/** 全部：代表优惠券状态全部，所有门店可用，所有专区可用等等 **/
	public static final String STATUS_ALL = "ALL";

	/** 优惠券状态-上架**/
	public static final String COUPON_STATUS_TO_LIST = "TO_LIST";

	/** 优惠券状态-草稿**/
	public static final String COUPON_STATUS_DRAFT = "DRAFT";

	/** 申请单状态-申请单提交中**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_IN_SUBMIT = "IN_SUBMIT";

	/** 申请单状态-处理中**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_IN_PROCESS = "IN_PROCESS";

	/** 申请单状态-待处理**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_PENDING = "PENDING";

	/** 申请单状态-已处理**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_PROCESS = "PROCESS";

	/** 申请单状态-作废**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_CANCEL = "CANCEL";

	/** 申请单状态-不通过**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_DISAGREE = "DISAGREE";

	/** 申请单状态-再次处理**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_AGAIN = "AGAIN";

	/** 申请单公共状态-失败**/
	public static final String BATCH_DISTRIBUTION_COMMON_STATUS_FAIL = "FAIL";

	/** 申请单状态-部分失败**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_SOME_FAIL = "SOME_FAIL";

	/** 申请单状态-异常**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_ABNORMAL = "ABNORMAL";

	/** 申请单清单状态-初始**/
	public static final String BATCH_DISTRIBUTION_APPLY_DETAIL_STATUS_INIT = "INIT";

	/** 申请单清单状态-初始-失败**/
	public static final String BATCH_DISTRIBUTION_APPLY_DETAIL_STATUS_INIT_FAIL = "INIT_FAIL";

	/** 申请单公共状态-成功**/
	public static final String BATCH_DISTRIBUTION_COMMON_STATUS_SUCCESS = "SUCCESS";

	/** 申请单日期状态-已通过 **/
	public static final String BATCH_DISTRIBUTION_LOG_STATUS_PASS = "PASS";

	/** 优惠券投放信息中公共日期模式-领取既（生效/失效） **/
	public static final String COUPON_LAUNCH_INFO_DATE_NOW = "NOW";

	/** 优惠券投放信息中公共日期模式-领取后XX天（生效/失效） **/
	public static final String COUPON_LAUNCH_INFO_DATE_MODEL_LAST_DAY = "LAST_DAY";

	/** 优惠券投放信息中公共日期模式-指定日期（生效/失效） **/
	public static final String COUPON_LAUNCH_INFO_DATE_MODEL_POINT_DATE = "POINT_DATE";

	/** 优惠券投放信息中公共日期模式-根据保单有效期计算（生效/失效） **/
	public static final String COUPON_LAUNCH_INFO_DATE_MODEL_POLICY_DATE = "POLICY_DATE";

	/** 优惠券投放信息中订单失效-优惠券失效后XX天（失效） **/
	public static final String COUPON_LAUNCH_INFO_COUPON_LAST_DAY_INVALID = "COUPON_LAST_DAY_INVALID";

	/** 用户券状态-未生效 **/
	public static final String USER_COUPON_STATUS_UN_EFFECTIVE = "UN_EFFECTIVE";

	/** 用户券状态-未使用 **/
	public static final String USER_COUPON_STATUS_NORMAL = "NORMAL";

	/** 用户券状态-已使用 **/
	public static final String USER_COUPON_STATUS_USED = "USED";

	/** 用户券状态-已过期 **/
	public static final String USER_COUPON_STATUS_INVALID = "INVALID";

	/** 用户券状态-已作废 **/
	public static final String USER_COUPON_STATUS_CANCEL = "CANCEL";

	/** 用户券状态-已冻结 **/
	public static final String USER_COUPON_STATUS_FROZEN = "FROZEN";

	/** 用户券发放模式-批量发放 **/
	public static final String USER_COUPON_GRANT_MODEL_BATCH = "BATCH";

	/** 用户券发放模式-会员领取 **/
	public static final String USER_COUPON_GRANT_MODEL_RECEIVE = "RECEIVE";

	/** 用户券发放模式-接口发放 **/
	public static final String USER_COUPON_GRANT_MODEL_INTERFACE = "INTERFACE";

	/** 用户券操作日志-调整有效期 **/
	public static final String USER_COUPON_OPERATE_LOG_CHANGEDATE = "CHANGEDATE";

	/** 平台（投放平台/使用平台）-SYY **/
	public static final String PLATFORM_CODE_SYY = "SYY";

	/** 用户券显示标志-Y显示 **/
	public static final String USER_COUPON_SHOW_FLAG = "Y";

	/** 用户券消耗记录表中删除标志-N未删除，Y-已删除 **/
	public static final String USER_COUPON_CONNSUME_DELETE_FLAG = "N";

	/** 用户券使用方式：SYSTEM-系统（前端正常使用）,MANUAL-后台手工补消耗 **/
	public static final String USER_COUPON_USE_WAY_SYSTEM = "SYSTEM";

	/** 油卡请求回调结果状态-成功 **/
	public static final String OIL_CARD_RESULT_STATUS_FAIL = "FAIL";

	/** 油卡请求操作类型-发券 **/
	public static final String OIL_CARD_REQUEST_OPERATE_TYPE_ADD = "ADD";

	/** 油卡请求操作类型-作废 **/
	public static final String OIL_CARD_REQUEST_OPERATE_TYPE_CANCEL = "CANCEL";

	/** 油卡请求操作类型-退回 **/
	public static final String OIL_CARD_REQUEST_OPERATE_TYPE_BACK = "BACK";

	/** 通知油卡结果状态-已通知 **/
	public static final String CALL_OIL_CARD_RESULT_STATUS_PROCESS = "PROCESS";

	/** 通知油卡结果状态-通知失败 **/
	public static final String CALL_OIL_CARD_RESULT_STATUS_FAIL = "FAIL";

	/** 通知油卡结果状态-异常 **/
	public static final String CALL_OIL_CARD_RESULT_STATUS_ABNORMAL = "ABNORMAL";

	/** 油卡用户券状态-充值中 **/
	public static final String OIL_CARD_USER_COUPON_IN_EXCHANGE = "IN_EXCHANGE";

	/** 油卡用户券状态-已兑换（已使用） **/
	public static final String OIL_CARD_USER_COUPON_STATUS_USED = "USED";

	/** 优惠券类型状态-启用 **/
	public static final String COUPON_TYPE_STATUS_OPEN = "OPEN";

	/** MQ 相关 **/
	/** 权益服务公共MQ交换器 **/
	public static final String EQUITY_MQ_COMMON_EXCHANGES = "EQUITY_COMMON_EXCHANGES";

	/** 权益服务-油卡发券-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_OIL_CARD_USER_COUPON = "EQUITY_OIL_CARD_USER_COUPON";

	/** 权益服务-发券结果通知-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_OIL_CARD_RESULT_CALL = "EQUITY_OIL_CARD_RESULT_CALL";

	/** 权益服务-充值-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_OIL_CARD_EXCHANGE = "EQUITY_OIL_CARD_EXCHANGE";

	/** 权益服务-充值结果-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_OIL_CARD_EXCHANGE_RESULT = "EQUITY_OIL_CARD_EXCHANGE_RESULT";

	/** 权益服务-更新优惠券发放数量-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_UPDATE_COUPON_GRANT_NUMBER = "EQUITY_UPDATE_COUPON_GRANT_NUMBER";

	private EquityConstants() {
	}

}
