package com.rocogz.syy.equity.entity.userCoupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.entity.coupon.EquityCouponInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 用户券基本信息 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-06 12:59:51</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_user_coupon_info")
public class EquityUserCouponInfo extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编号
     */
    private String code;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券类型编号
     */
    private String couponTypeCode;

    /**
     * 兑换码
     */
    private String redeemCode;

    /**
     * 状态：未生效、未使用、已使用、已过期、已冻结、已作废
     */
    private String status;

    /**
     * 优惠券信息
     */
    @TableField(exist = false)
    private EquityCouponInfo couponInfo;

    /**
     * 用户券会员信息
     */
    @TableField(exist = false)
    private EquityUserCouponUserInfo userInfo;

    /**
     * 用户券使用信息
     */
    @TableField(exist = false)
    private EquityUserCouponUseInfo useInfo;

    /**
     * 用户券投放信息
     */
    @TableField(exist = false)
    private EquityUserCouponLaunchInfo launchInfo;

}
