package com.rocogz.syy.equity.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 代金券金额、折扣率相关 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-06-17 17:50:36</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_cash_coupon_amount")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityCashCouponAmount extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 金额使用限制
     */
    private BigDecimal amountUseLimit;

    /**
     * 折扣率：无折扣为1。
     */
    private BigDecimal discountRate;

    /**
     * 面值
     */
    private BigDecimal faceValue;


}
