package com.rocogz.syy.equity.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.equity.dto.equity.OilCashAndOilCardCouponDto;
import com.rocogz.syy.equity.dto.equity.oilCardUserCoupon.OilCardUserCouponBatchExchangeDto;
import com.rocogz.syy.equity.dto.equity.userCoupon.UserCouponDto;
import com.rocogz.syy.equity.dto.issuingBody.IssuingBodyDto;
import com.rocogz.syy.equity.dto.tree.IssuingBodyTreeDto;
import com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionApplyOperateLog;
import com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApply;
import com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApplyDetail;
import com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponResultRecord;
import com.rocogz.syy.equity.entity.coupon.EquityCashCouponAmount;
import com.rocogz.syy.equity.entity.coupon.EquityCouponInfo;
import com.rocogz.syy.equity.entity.coupon.EquityCouponLaunchInfo;
import com.rocogz.syy.equity.entity.couponType.EquityCouponType;
import com.rocogz.syy.equity.entity.issuingBody.IssuingBody;
import com.rocogz.syy.equity.entity.oilCardUserCoupon.EquityOilCardUserCoupon;
import com.rocogz.syy.equity.entity.oilCardUserCoupon.EquityOilCardUserCouponConsume;
import com.rocogz.syy.equity.entity.oilCardUserCoupon.EquityOilCardUserCouponRequestOperateSerial;
import com.rocogz.syy.equity.entity.oilCardUserCoupon.EquityOilCardUserCouponRequestRecord;
import com.rocogz.syy.equity.entity.userCoupon.EquityUserCouponConsume;
import com.rocogz.syy.equity.entity.userCoupon.EquityUserCouponInfo;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>Description: 权益服务对外接口 service</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-05 20:08:42</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
public interface IEquityClientService {

    /***********************************************  Andy 优惠券相关 Start   *****************************************************************/
    /**
     * 优惠券信息保存
     *
     * @param equityCouponInfo 优惠券信息
     * @return
     */
    @PostMapping("/api/equity/coupon/saveOrUpdateCoupon")
    void saveOrUpdateCoupon(@RequestBody EquityCouponInfo equityCouponInfo);

    /**
     * 优惠券列表查询
     *
     * @param code      编码
     * @param name      名称
     * @param status    状态
     * @param typeCode  类型
     * @param startTime 创建开始时间
     * @param endTime   创建结束时间
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/equity/coupon/searchCoupon")
    PageTable<EquityCouponInfo> searchCoupon(@RequestParam(value = "code", required = false) String code,
                                             @RequestParam(value = "name", required = false) String name,
                                             @RequestParam(value = "status", required = false) String status,
                                             @RequestParam(value = "typeCode", required = false) String typeCode,
                                             @RequestParam(value = "startTime", required = false) String startTime,
                                             @RequestParam(value = "endTime", required = false) String endTime,
                                             @RequestParam(value = "limit", defaultValue = "20") int limit,
                                             @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 提供创建活动选择优惠券
     *
     * @param areaCodeList 专区编号
     * @param status       状态（默认为上架）
     * @param name         名称
     * @param code         编码
     * @param limit        每页记录
     * @param page         页码
     * @return
     */
    @GetMapping("/api/equity/coupon/searchCouponForActivity")
    PageTable<EquityCouponInfo> searchCouponForActivity(@RequestParam(value = "areaCodeList") List<String> areaCodeList,
                                                        @RequestParam(value = "status", defaultValue = "TO_LIST") String status,
                                                        @RequestParam(value = "name", required = false) String name,
                                                        @RequestParam(value = "code", required = false) String code,
                                                        @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                        @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据优惠券编号list查询优惠券信息
     *
     * @param codeList 编号list
     * @return
     */
    @GetMapping("/api/equity/coupon/findCouponInfoByCodeList")
    Response<List<EquityCouponInfo>> findCouponInfoByCodeList(@RequestParam(value = "codeList") List<String> codeList);

    /**
     * 根据优惠券编号删除
     *
     * @param code 优惠券编号
     * @return
     */
    @GetMapping("/api/equity/coupon/deleteCouponByCode")
    Response deleteCouponByCode(@RequestParam(value = "code") String code);

    /**
     * 根据优惠券编号更新状态
     *
     * @param code   优惠券编号
     * @param status 状态
     * @return
     */
    @GetMapping("/api/equity/coupon/updateCouponStatus")
    Response updateCouponStatus(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status);

    /**
     * 根据优惠券编号查询
     *
     * @param code 优惠券编号
     * @return
     */
    @GetMapping("/api/equity/coupon/getCouponByCode")
    Response<EquityCouponInfo> getCouponByCode(@RequestParam(value = "code") String code);

    /**
     * 追加投放数量
     *
     * @param couponCode 优惠券编号
     * @param quantity   数量
     * @return
     */
    @GetMapping("/api/equity/couponLaunch/addCouponTotalQuantity")
    Response addCouponTotalQuantity(@RequestParam(value = "couponCode") String couponCode,
                                    @RequestParam(value = "quantity") Integer quantity);

    /**
     * 减少投放数量
     *
     * @param couponCode 优惠券编号
     * @param quantity   数量
     * @return
     */
    @GetMapping("/api/equity/couponLaunch/subtractCouponTotalQuantity")
    Response subtractCouponTotalQuantity(@RequestParam(value = "couponCode") String couponCode,
                                         @RequestParam(value = "quantity") Integer quantity);

    /**
     * 更新优惠券领取数量
     * @param couponCode  优惠券编号
     * @param grantNumber   领取数量
     * @return
     */
    @GetMapping("/api/equity/couponLaunch/updateGrantNumber")
    Response updateGrantNumber(@RequestParam(value = "couponCode") String couponCode,
                               @RequestParam(value = "grantNumber") Integer grantNumber);

    /**
     * 根据状态查询优惠券类型
     *
     * @param status 类型状态：OPEN-启用，CLOSE-停用
     * @return
     */
    @GetMapping("/api/equity/couponType/findCouponTypeByStatus")
    Response<List<EquityCouponType>> findCouponTypeByStatus(@RequestParam(value = "status", required = false) String status);

    /**
     * 获取优惠券投放信息
     *
     * @param couponCodeList 优惠券编号
     * @return
     */
    @GetMapping("/api/equity/couponLaunch/getCouponLaunchInfoMap")
    Response<Map<String, EquityCouponLaunchInfo>> getCouponLaunchInfoMap(@RequestParam(value = "couponCodeList") List<String> couponCodeList);

    /*********************************************   优惠券相关 end   *************************************************************************/

    /*********************************************   优惠券发放申请单 start  *******************************************************************/

    /**
     * 新增
     *
     * @param equityBatchDistributionCouponApply 申请单主信息
     * @return
     */
    @PostMapping("/api/equity/batchDistributionCouponApply/saveBatchDistributionCouponApply")
    Response saveBatchDistributionCouponApply(@RequestBody EquityBatchDistributionCouponApply equityBatchDistributionCouponApply);

    /**
     * 申请单列表查询
     *
     * @param applyNo    申请单编号
     * @param sourceCode 投放主体
     * @param status     状态
     * @param startDate  开始日期
     * @param endDate    结束日期
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/equity/batchDistributionCouponApply/searchBatchDistributionCouponApply")
    PageTable<EquityBatchDistributionCouponApply> searchBatchDistributionCouponApply(@RequestParam(value = "applyNo", required = false) String applyNo,
                                                                                     @RequestParam(value = "sourceCode", required = false) String sourceCode,
                                                                                     @RequestParam(value = "status", required = false) String status,
                                                                                     @RequestParam(value = "startDate", required = false) String startDate,
                                                                                     @RequestParam(value = "endDate", required = false) String endDate,
                                                                                     @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                                     @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 批量发券申请单-通过
     *
     * @param applyNo     申请单编号
     * @param operateUser 操作用户
     * @return
     */
    @GetMapping("/api/equity/batchDistributionCouponApply/batchDistributionApplyPass")
    Response batchDistributionApplyPass(@RequestParam(value = "applyNo") String applyNo, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 申请不通过
     *
     * @param applyNo 申请单编号
     * @return
     */
    @GetMapping("/api/equity/batchDistributionCouponApply/batchDistributionApplyDisagree")
    Response batchDistributionApplyDisagree(@RequestParam(value = "applyNo") String applyNo, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 批量发券申请单-再次处理
     *
     * @param applyNo     申请单编号
     * @param operateUser 操作用户
     * @return
     */
    @GetMapping("/api/equity/batchDistributionCouponApply/batchDistributionApplyAgain")
    Response batchDistributionApplyAgain(@RequestParam(value = "applyNo") String applyNo, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 批量发券申请单-作废
     *
     * @param applyNo     申请单编号
     * @param operateUser 操作用户
     * @return
     */
    @GetMapping("/api/equity/batchDistributionCouponApply/batchDistributionApplyCancel")
    Response batchDistributionApplyCancel(@RequestParam(value = "applyNo") String applyNo, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 根据申请单编号查询发放申请单
     *
     * @param applyNo 申请单编号
     * @return
     */
    @GetMapping("/api/equity/batchDistributionCouponApply/getBatchDistributionApplyByApplyNo")
    Response<EquityBatchDistributionCouponApply> getBatchDistributionApplyByApplyNo(@RequestParam(value = "applyNo") String applyNo);

    /**
     * 根据申请单编号查询批量发券优惠券结果记录
     *
     * @param applyNo 申请单编号
     * @return
     */
    @GetMapping("/api/equity/batchDistributionResultRecord/findBatchDistributionCouponResultRecordByApplyNo")
    Response<List<EquityBatchDistributionCouponResultRecord>> findBatchDistributionCouponResultRecordByApplyNo(@RequestParam(value = "applyNo") String applyNo);

    /**
     * 根据申请单编号查询批量发券清单列表查询
     *
     * @param applyNo 申请单编号
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/equity/batchDistributionCouponApplyDetail/searchBatchDistributionApplyDetail")
    PageTable<EquityBatchDistributionCouponApplyDetail> searchBatchDistributionApplyDetail(@RequestParam(value = "applyNo") String applyNo,
                                                                                           @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                                           @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 批量发券申请单操作日志列表查询
     *
     * @param applyNo 申请单编号
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/equity/batchDistributionApplyOperateLog/searchBatchDistributionApplyDetail")
    PageTable<EquityBatchDistributionApplyOperateLog> searchBatchDistributionApplyOperateLog(@RequestParam(value = "applyNo") String applyNo,
                                                                                             @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                                             @RequestParam(value = "page", defaultValue = "1") int page);

    /*********************************************   优惠券发放申请单 end   ********************************************************************/

    /*********************************************   用户券相关 start   ********************************************************************/

    /**
     * 发放用户券
     *
     * @param userCouponDto 用户券发放参数dto
     * @return
     * @throws Exception
     */
    @PostMapping("/api/equity/userCoupon/grantUserCoupon")
    Response<EquityUserCouponInfo> grantUserCoupon(@RequestBody UserCouponDto userCouponDto);

    /**
     * 用户券列表查询-后台管理
     *
     * @param code           用户券编号
     * @param userCode       会员编号
     * @param mobile         手机号
     * @param couponCode     优惠券编号
     * @param couponTypeCode 优惠券类型
     * @param activityCode   活动编号
     * @param status         状态
     * @param sourceCode     发放主体
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/equity/userCoupon/searchUserInfo")
    PageTable<EquityUserCouponInfo> searchUserInfo(@RequestParam(value = "code", required = false) String code,
                                                   @RequestParam(value = "userCode", required = false) String userCode,
                                                   @RequestParam(value = "mobile", required = false) String mobile,
                                                   @RequestParam(value = "couponCode", required = false) String couponCode,
                                                   @RequestParam(value = "couponTypeCode", required = false) String couponTypeCode,
                                                   @RequestParam(value = "activityCode", required = false) String activityCode,
                                                   @RequestParam(value = "status", required = false) String status,
                                                   @RequestParam(value = "sourceCode", required = false) String sourceCode,
                                                   @RequestParam(value = "receiveFlag", required = false) String receiveFlag,
                                                   @RequestParam(value = "receiveStartDate", required = false) String receiveStartDate,
                                                   @RequestParam(value = "receiveEndDate", required = false) String receiveEndDate,
                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 用户券列表查询-车主端
     * @param type   类型
     * @param status 状态
     * @param openId openid
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/equity/userCoupon/searchUserInfoForCar")
    PageTable<EquityUserCouponInfo> searchUserInfoForCar(@RequestParam(value = "type") String type,
                                                         @RequestParam(value = "status", required = false) String status,
                                                         @RequestParam(value = "amountLimit", required = false) String amountLimit,
                                                         @RequestParam(value = "openId") String openId,
                                                         @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                         @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 领券中心查询用户券信息
     *
     * @param couponCodeList   优惠券编号List
     * @param activityCodeList 活动编号List
     * @param openId           openId
     * @param status           状态
     * @return
     */
    @GetMapping("/api/equity/userCoupon/findUserCouponForCouponCenter")
    Response<List<EquityUserCouponInfo>> findUserCouponForCouponCenter(@RequestParam(value = "couponCodeList") List<String> couponCodeList,
                                                                       @RequestParam(value = "activityCodeList") List<String> activityCodeList,
                                                                       @RequestParam(value = "openId") String openId,
                                                                       @RequestParam(value = "status", required = false) String status);

    /**
     * 根据用户券编号查询用户券信息-车主端
     *
     * @param code   用户券编号
     * @param openId
     * @return
     */
    @GetMapping("/api/equity/userCoupon/getUserCouponInfoByCodeAndOpenId")
    Response<EquityUserCouponInfo> getUserCouponInfoByCodeAndOpenId(@RequestParam(value = "code") String code,
                                                                    @RequestParam(value = "openId") String openId);

    /**
     * 根据用户券编号查询用户券信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/equity/userCoupon/getUserCouponInfoByCode")
    Response<EquityUserCouponInfo> getUserCouponInfoByCode(@RequestParam(value = "code") String code);

    /**
     * 根据用户券生效、失效日期更新券状态为已生效或者已失效
     *
     * @return
     */
    @GetMapping("/api/equity/userCoupon/updateUserCouponStatusByEffectiveDateOrInvalidDate")
    void updateUserCouponStatusByEffectiveDateOrInvalidDate();

    /**
     * 批量兑换代金券
     * @param platformCode      使用平台
     * @param redeemCodeList    兑换码列表
     * @param orderCode         订单编号
     * @param openId
     * @return
     */
    @PostMapping("/api/equity/userCoupon/batchConsumeCashByRedeemCode")
    Response batchConsumeCashByRedeemCode(@RequestParam(value = "platformCode") String platformCode,
                                                 @RequestParam(value = "redeemCodeList") List<String> redeemCodeList,
                                                 @RequestParam(value = "orderCode") String orderCode,
                                                 @RequestParam(value = "orderAmount") BigDecimal orderAmount,
                                                 @RequestParam(value = "openId") String openId);


    /**
     * 根据兑换码列表、openId查询优惠券信息
     * @param openId
     * @param redeemCodeList    兑换码列表
     */
    @GetMapping("/api/equity/userCoupon/findCashCouponByRedeemCode")
    Response<List<EquityCashCouponAmount>> findCashCouponByRedeemCode(@RequestParam(value = "openId") String openId,
                                                                      @RequestParam(value = "redeemCodeList") List<String> redeemCodeList);

    /**
     * 根据手机号更新用户券会员信息
     *
     * @param mobile         手机号
     * @param idType         证件类型
     * @param idCardExplicit 证件号码
     * @param openId         openid
     * @return
     */
    @GetMapping("/api/equity/userCouponUserInfo/updateUserCouponUserInfoByMobile")
    Response updateUserCouponUserInfoByMobile(@RequestParam(value = "mobile") String mobile,
                                              @RequestParam(value = "userCode") String userCode,
                                              @RequestParam(value = "idType", required = false) String idType,
                                              @RequestParam(value = "idCardExplicit", required = false) String idCardExplicit,
                                              @RequestParam(value = "openId") String openId);

    /**
     * 统计用户券各类型待使用的张数
     * @param openId
     */
    @GetMapping("/api/equity/userCouponUserInfo/countUserCouponNumberByOpenId")
    Response<Map<String, String>> countUserCouponNumberByOpenId(@RequestParam(value = "openId") String openId);

    /**
     * 更新用户券状态updateUserCouponStatus
     *
     * @param code        用户券编号
     * @param couponCode  优惠券编号
     * @param status      状态
     * @param operateUser 操作用户
     * @return
     */
    @GetMapping("/api/equity/userCoupon/updateUserCouponStatus")
    Response updateUserCouponStatus(@RequestParam(value = "code") String code,
                                    @RequestParam(value = "couponCode") String couponCode,
                                    @RequestParam(value = "status") String status,
                                    @RequestParam(value = "operateUser") String operateUser);

    /**
     * 更新用户券有效期
     *
     * @param userCouponCode 用户券编号
     * @param couponCode     优惠券信息
     * @param effectiveDate  生效日期
     * @param invalidDate    失效日期
     * @return
     */
    @GetMapping("/api/equity/userCouponUseInfo/updateUserCouponDate")
    Response updateUserCouponDate(@RequestParam(value = "userCouponCode") String userCouponCode,
                                  @RequestParam(value = "couponCode") String couponCode,
                                  @RequestParam(value = "effectiveDate") String effectiveDate,
                                  @RequestParam(value = "invalidDate") String invalidDate,
                                  @RequestParam(value = "operateUser") String operateUser);

    /**
     * 根据核销码查询优惠券信息
     *
     * @param redeemCode 核销码
     * @return
     */
    @GetMapping("/api/equity/userCoupon/getUserCouponByRedeemCode")
    Response<EquityUserCouponInfo> getUserCouponByRedeemCode(@RequestParam(value = "redeemCode") String redeemCode);

    /**
     * 根据核销码、第三方订单查询优惠券信息
     * @param redeemCode   核销码
     * @param thirdCode    第三方编号
     * @return
     */
    @GetMapping("/api/equity/userCoupon/getUserCouponByRedeemCodeThirdCode")
    Response<EquityUserCouponInfo> getUserCouponByRedeemCodeThirdCode(@RequestParam(value = "redeemCode", required = false) String redeemCode,
                                                                             @RequestParam(value = "thirdCode", required = false) String thirdCode);

    /**
     * 用户券消耗使用
     *
     * @param platformCode 使用平台
     * @param redeemCode   券码
     * @param orderCode    订单编号
     * @param useWay       使用方式
     * @return
     */
    @PostMapping("/api/equity/userCoupon/consumeByRedeemCode")
    Response consumeByRedeemCode(@RequestParam(value = "platformCode") String platformCode,
                                 @RequestParam(value = "redeemCode") String redeemCode,
                                 @RequestParam(value = "orderCode") String orderCode,
                                 @RequestParam(value = "useWay") String useWay);

    /**
     * 用户券退还
     * @param platformCode      平台码
     * @param codeList          用户券编号
     * @param orderCode         订单编号
     * @return
     */
    @PostMapping("/api/equity/userCoupon/userCouponReturn")
    Response userCouponReturn(@RequestParam(value = "platformCode") String platformCode,
                                     @RequestParam(value = "codeList") List<String> codeList,
                                     @RequestParam(value = "orderCode") String orderCode);


    /**
     * 获取未领取的用户券
     * @param openId
     * @return
     */
    @GetMapping("/api/equity/userCoupon/findUnrReceiveUserCoupon")
    Response<Integer> findUnrReceiveUserCoupon(@RequestParam(value = "openId") String openId);


    /**
     * 更新用户券、油卡券领取状态
     * @param openId
     * @return
     */
    @GetMapping("/api/equity/userCoupon/updateUserCouponReceiveFlag")
    Response updateUserCouponReceiveFlag(@RequestParam(value = "openId") String openId);


    /**
     * 用户券消耗记录列表
     *
     * @param userCouponCode 用户券编号
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/equity/userCouponConsume/searchUserCouponConsume")
    PageTable<EquityUserCouponConsume> searchUserCouponConsume(@RequestParam(value = "userCouponCode") String userCouponCode,
                                                               @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                               @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据用户券编号查询订单编号
     *
     * @param userCouponCode 用户券编号
     * @return
     */
    @GetMapping("/api/equity/userCouponConsume/getOrderCodeByUserCouponCode")
    Response<List<String>> getOrderCodeByUserCouponCode(@RequestParam(value = "userCouponCode") String userCouponCode);

    /*********************************************   用户券相关 end   ********************************************************************/

    /*********************************************  尹世豪 发放主体相关 Start   ****************************************************************/
    /**
     * 左侧发放主体树列表
     *
     * @return
     */
    @GetMapping("/api/equity/issuingBody/findIssuingBodyTree/{type}")
    Response<List<IssuingBodyTreeDto>> findIssuingBodyTree(@PathVariable("type") String type);

    /**
     * 根据主体id获取发放主体信息
     *
     * @param id 主体id
     * @return 发放主体dto对象
     */
    @GetMapping("/api/equity/issuingBody/getIssuingBodyById/{id}")
    Response<IssuingBodyDto> getIssuingBodyById(@PathVariable("id") Integer id);

    /**
     * 根据主体编码获取发放主体信息
     *
     * @param code 主体编码
     * @return 发放主体dto对象
     */
    @GetMapping("/api/equity/issuingBody/getIssuingBodyByCode/{code}")
    Response<IssuingBodyDto> getIssuingBodyByCode(@PathVariable("code") String code);

    /**
     * 根据上级编码查询对应的下级主体列表
     *
     * @param pCode
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/equity/issuingBody/getIssuingBodyListByPCode/{pCode}")
    PageTable<IssuingBodyDto> getIssuingBodyListByPCode(@PathVariable("pCode") String pCode,
                                                        @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                        @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据主体id删除主体
     *
     * @param id
     * @return
     */
    @GetMapping("/api/equity/issuingBody/deleteIssuingBodyById/{id}")
    Response deleteIssuingBodyById(@PathVariable("id") Integer id);

    /**
     * 根据主体id修改状态
     *
     * @param issuingBody
     * @return
     */
    @PostMapping("/api/equity/issuingBody/changeIssuingBodyStatusById")
    Response changeIssuingBodyStatusById(@RequestBody IssuingBody issuingBody);

    /**
     * 创建或更新主体
     *
     * @param issuingBody
     * @return
     */
    @PostMapping("/api/equity/issuingBody/saveOrUpdateIssuingBody")
    Response saveOrUpdateIssuingBody(@RequestBody IssuingBody issuingBody);

    /**
     * 获取发放主体列表(分页),不分类型
     *
     * @param code  主体编码 (精确匹配)
     * @param name  主体名称(模糊匹配)
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/equity/issuingBody/findIssuingBodyList")
    PageTable<IssuingBody> findIssuingBodyList(@RequestParam(value = "code", required = false) String code,
                                               @RequestParam(value = "name", required = false) String name,
                                               @RequestParam(value = "limit", defaultValue = "20") int limit,
                                               @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据发放主体编码列表查询 发放主体列表
     *
     * @param codes
     * @return
     */
    @PostMapping("/api/equity/issuingBody/getIssuingBodyListByCodes")
    Response<List<IssuingBody>> getIssuingBodyListByCodes(@RequestBody List<String> codes);

    /**
     * 根据机构代码 查询 发放主体编号
     * @param linkedBodyCode
     * @return
     */
    @GetMapping("/api/equity/issuingBody/getCodeByLinkedBodyCode")
    Response<String> getCodeByLinkedBodyCode(@RequestParam("linkedBodyCode") String linkedBodyCode);

    /*********************************************   发放主体相关 End   *******************************************************************/

    /*********************************************   Andy 电子加油券相关 start   *******************************************************************/
    /**
     * 验证订单请求的操作是否已存在
     *
     * @param orderCode 订单编号
     * @param type      操作类型：ADD-发券，CANCEL-作废，BACK-退回
     * @return
     */
    @GetMapping("/api/equity/oilCardRequestRecord/checkOrderIsExistByOrderCode")
    Response<EquityOilCardUserCouponRequestRecord> checkOrderIsExistByOrderCode(@RequestParam(value = "orderCode") String orderCode, @RequestParam(value = "type") String type);

    /**
     * 新增油卡请求参数记录
     *
     * @param entity
     * @return
     * @throws Exception
     */
    @PostMapping("/api/equity/oilCardRequestRecord/saveOilCardRequestRecord")
    Response saveOilCardRequestRecord(@RequestBody EquityOilCardUserCouponRequestRecord entity);

    /**
     * 根据订单编号查询油卡请求信息记录
     *
     * @param oilOrderCode 订单编号
     * @return
     */
    @GetMapping("/api/equity/oilCardRequestRecord/getOilCardUserCouponRequestRecordByOilOrderCode")
    Response<EquityOilCardUserCouponRequestRecord> getOilCardUserCouponRequestRecordByOilOrderCode(@RequestParam(value = "oilOrderCode") String oilOrderCode);

    /**
     * 更新请求记录发放状态
     * @param orderCode    订单编号
     * @param oldStatus    更新前状态（INIT-初始）
     * @param newStatus    更新发放状态（SUCCESS-成功，FAIL-失败）
     */
    @GetMapping("/api/equity/oilCardRequestRecord/updateOilCardRequestRecordStatus")
    Response updateOilCardRequestRecordStatus(@RequestParam(value = "orderCode") String orderCode,
                                                     @RequestParam(value = "oldStatus") String oldStatus,
                                                     @RequestParam(value = "newStatus") String newStatus);

    /**
     * 查询油卡券发放失败的数据
     * @return
     */
    @GetMapping("/api/equity/oilCardRequestRecord/findOilCardUserCouponGranFailAndToInProcess")
    Response<List<EquityOilCardUserCouponRequestRecord>> findOilCardUserCouponGranFailAndToInProcess();

    /**
     * 新增操作流水
     *
     * @param orderCode 订单编号
     * @param type      操作类型
     * @return
     */
    @PostMapping("/api/equity/oilCardRequestOperateSerial/saveOperateSerial")
    void saveOperateSerial(@RequestParam(value = "orderCode") String orderCode,
                           @RequestParam(value = "type") String type);

    /**
     * 更新操作流水状态
     *
     * @param orderCode    订单编号
     * @param type         操作类型（ADD-发券、CANCEL-作废、BACK-退回）
     * @param resultStatus 结果（PROCESS-已通知，FAIL-通知失败，ABNORMAL-通知异常）
     * @param rmk          备注
     */
    @GetMapping("/api/equity/oilCardRequestOperateSerial/updateOperateSerial")
    Response updateOperateSerial(@RequestParam(value = "orderCode") String orderCode,
                                 @RequestParam(value = "type") String type,
                                 @RequestParam(value = "resultStatus") String resultStatus,
                                 @RequestParam(value = "rmk", required = false) String rmk);

    /**
     * 查询处理失败的结果并且更新为处理中
     *
     * @return
     */
    @GetMapping("/api/equity/oilCardRequestOperateSerial/findFailAndToInProcess")
    Response<List<EquityOilCardUserCoupon>> findFailAndToInProcess();

    /**
     * 根据油卡订单编号查询对应的油卡请求操作流水 (分页)
     *
     * @param oilOrderCode 油卡订单编号
     * @param limit        每页条数
     * @param page         当前页
     * @return
     */
    @GetMapping("/api/equity/oilCardRequestOperateSerial/findOilCardUserCouponRequestOperateSerialList")
    PageTable<EquityOilCardUserCouponRequestOperateSerial> findOilCardUserCouponRequestOperateSerialList(@RequestParam(value = "oilOrderCode") String oilOrderCode,
                                                                                                         @RequestParam(defaultValue = "20", value = "limit") int limit,
                                                                                                         @RequestParam(defaultValue = "1", value = "page") int page);

    /**
     * 保存油卡用户券
     * @param oilOrderCode      油卡订单号
     * @param orderAmount       订单金额
     * @param mobile            手机号
     * @param idType            证件类型
     * @param idCard            证件号码
     * @param policyNo          保单号
     * @param licenseNo         车牌号
     * @param policyOrgCode     承保机构
     * @param productCode       产品编码
     * @param createTime        发放时间
     * @return
     */
    @PostMapping("/api/equity/oilCardUserCoupon/saveOilCardUserCoupon")
    Response<EquityOilCardUserCoupon> saveOilCardUserCoupon(@RequestParam(value = "oilOrderCode") String oilOrderCode,
                                                                   @RequestParam(value = "orderAmount") BigDecimal orderAmount,
                                                                   @RequestParam(value = "mobile") String mobile,
                                                                   @RequestParam(value = "idType", required = false) String idType,
                                                                   @RequestParam(value = "idCard", required = false) String idCard,
                                                                   @RequestParam(value = "policyNo", required = false) String policyNo,
                                                                   @RequestParam(value = "licenseNo", required = false) String licenseNo,
                                                                   @RequestParam(value = "policyOrgCode", required = false) String policyOrgCode,
                                                                   @RequestParam(value = "productCode", required = false) String productCode,
                                                                   @RequestParam(value = "createTime") String createTime);

    /**
     * 油卡系统用户券列表
     *
     * @param status 状态
     * @param openId openid
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/equity/oilCardUserCoupon/searchOilUserCoupon")
    PageTable<EquityOilCardUserCoupon> searchOilUserCoupon(@RequestParam(value = "status", required = false) String status,
                                                           @RequestParam(value = "openId") String openId,
                                                           @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                           @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 后台查询电子券(专用)列表
     *
     * @param code         电子券编码
     * @param oilOrderCode 油卡订单编号
     * @param name         电子券名称
     * @param userCode     会员编码
     * @param openId       微信openid
     * @param mobile       手机号
     * @param licenseNo    车牌号
     * @param policyNo     保单号
     * @param status       状态
     * @param limit        每页条数
     * @param page         当前页
     * @return
     */
    @GetMapping("/api/equity/oilCardUserCoupon/findOilUserCouponList")
    PageTable<EquityOilCardUserCoupon> findOilUserCouponList(@RequestParam(required = false, value = "code") String code,
                                                             @RequestParam(required = false, value = "oilOrderCode") String oilOrderCode,
                                                             @RequestParam(required = false, value = "name") String name,
                                                             @RequestParam(required = false, value = "userCode") String userCode,
                                                             @RequestParam(required = false, value = "openId") String openId,
                                                             @RequestParam(required = false, value = "mobile") String mobile,
                                                             @RequestParam(required = false, value = "licenseNo") String licenseNo,
                                                             @RequestParam(required = false, value = "policyNo") String policyNo,
                                                             @RequestParam(required = false, value = "status") String status,
                                                             @RequestParam(required = false, value = "receiveFlag") String receiveFlag,
                                                             @RequestParam(required = false, value = "receiveStartTime") String receiveStartTime,
                                                             @RequestParam(required = false, value = "receiveEndTime") String receiveEndTime,
                                                             @RequestParam(defaultValue = "20", value = "limit") int limit,
                                                             @RequestParam(defaultValue = "1", value = "page") int page);

    /**
     * 根据油卡用户券编码查询油卡用户券信息
     *
     * @param code 油卡用户券编码
     * @return
     */
    @GetMapping("/api/equity/oilCardUserCoupon/getOilCardUserCouponByCode")
    Response<EquityOilCardUserCoupon> getOilCardUserCouponByCode(@RequestParam(value = "code") String code);

    /**
     * 根据用户统计待使用的油卡总额
     *
     * @param openId
     * @return
     */
    @GetMapping("/api/equity/oilCardUserCoupon/getOilCardTotalAmountByOpenId")
    Response<BigDecimal> getOilCardTotalAmountByOpenId(@RequestParam(value = "openId") String openId);

    /**
     * 根据用户券兑换码查询油卡用户券
     *
     * @param redeemCode 用户券兑换码
     * @param openId     openid
     * @return
     */
    @GetMapping("/api/equity/oilCardUserCoupon/getOilCardUserCouponByRedeemCode")
    Response<EquityOilCardUserCoupon> getOilCardUserCouponByRedeemCode(@RequestParam(value = "redeemCode") String redeemCode,
                                                                       @RequestParam(value = "openId") String openId);

    /**
     * 根据用户券编号查询油卡用户券详情
     *
     * @param redeemCode 用户券兑换码
     * @param orderCode  订单编号
     * @return
     */
    @GetMapping("/api/equity/oilCardUserCoupon/getOilCardUserCouponDetail")
    Response<EquityOilCardUserCoupon> getOilCardUserCouponDetail(@RequestParam(value = "redeemCode", required = false) String redeemCode,
                                                                 @RequestParam(value = "orderCode") String orderCode);

    /**
     * 更新油卡用户券状态
     *
     * @param redeemCode 用户券兑换码
     * @param oldStatus  更新前状态
     * @param status     更新状态
     * @return
     */
    @GetMapping("/api/equity/oilCardUserCoupon/updateOilCardUserCoupon")
    Response updateOilCardUserCoupon(@RequestParam(value = "redeemCode") String redeemCode,
                                     @RequestParam(value = "oldStatus") String oldStatus,
                                     @RequestParam(value = "status") String status);

    /**
     * 油卡充值
     *
     * @param redeemCode  用户券兑换码
     * @param orderCode   订单编号
     * @param orderAmount 订单金额
     * @param openId      openId
     * @param oldStatus   更新前状态
     * @param status      状态
     * @return
     */
    @GetMapping("/api/equity/oilCardUserCoupon/oilCardUserCouponExchange")
    Response oilCardUserCouponExchange(@RequestParam(value = "redeemCode") String redeemCode,
                                       @RequestParam(value = "orderCode") String orderCode,
                                       @RequestParam(value = "orderAmount") BigDecimal orderAmount,
                                       @RequestParam(value = "openId") String openId,
                                       @RequestParam(value = "oldStatus") String oldStatus,
                                       @RequestParam(value = "status") String status);

    /**
     * 油卡批量充值
     *
     * @param exchangeDto 兑换信息
     * @return
     */
    @PostMapping("/api/equity/oilCardUserCoupon/oilCardUserCouponBatchExchange")
    Response oilCardUserCouponBatchExchange(@RequestBody OilCardUserCouponBatchExchangeDto exchangeDto);

    /**
     * 更新油卡用户券为已过期
     */
    @GetMapping("/api/equity/oilCardUserCoupon/updateOilCardUserCouponInvalidByInvalidDate")
    void updateOilCardUserCouponInvalidByInvalidDate();

    /**
     * 根据用户券编号查询对应的电子加油券消耗记录 (分页)
     *
     * @param userCouponCode 用户券编号
     * @param limit          每页条数
     * @param page           当前页
     * @return
     */
    @GetMapping("/api/equity/oilCardUserCouponConsume/findOilCardUserCouponConsumeList")
    PageTable<EquityOilCardUserCouponConsume> findOilCardUserCouponConsumeList(@RequestParam(value = "userCouponCode") String userCouponCode,
                                                                               @RequestParam(defaultValue = "20", value = "limit") int limit,
                                                                               @RequestParam(defaultValue = "1", value = "page") int page);
    /*********************************************   电子加油券相关 end   *******************************************************************/

    /**
     * 根据充值额度统计可用优惠券张数
     * @param openId
     * @param amountLimit   额度
     */
    @GetMapping("/api/equity/userCouponOilCash/countCashCouponNumberByAmountLimit")
    Response countCashCouponNumberByAmountLimit(@RequestParam(value = "openId") String openId,
                                                       @RequestParam(value = "amountLimit") String amountLimit);

    /**
     * 查询代金券、电子兑换券
     * @param openId
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/equity/oilCashAndOilCardCoupon/findCashAndOilCardCoupon")
    PageTable<OilCashAndOilCardCouponDto> findCashAndOilCardCoupon(@RequestParam(value = "openId") String openId,
                                                                     @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                     @RequestParam(value = "page", defaultValue = "1") int page);
}
