package com.rocogz.syy.equity.dto.tree;

import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.entity.issuingBody.IssuingBody;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 法法主体树封装类</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/8  14:26</dd>
 * <dd>@author：yinshihao/dd>
 * </dl>
 */
public class IssuingBodyTreeDto extends IdEntity {

    private static final long serialVersionUID = 1L;

    private String name;

    private String title;

    private Boolean spread;

    private List<IssuingBodyTreeDto> children;

    private IssuingBody issuingBody;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Boolean getSpread() {
        if(this.spread == null){
            return false;
        }
        return spread;
    }

    public void setSpread(Boolean spread) {
        this.spread = spread;
    }

    public List<IssuingBodyTreeDto> getChildren() {
        return children;
    }

    public void setChildren(List<IssuingBodyTreeDto> children) {
        this.children = children;
    }

    public IssuingBody getIssuingBody() {
        return issuingBody;
    }

    public void setIssuingBody(IssuingBody issuingBody) {
        this.issuingBody = issuingBody;
    }
}
