package com.rocogz.syy.equity.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 优惠券使用信息表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-06 12:39:11</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_coupon_use_info")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityCouponUseInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 可用范围：指定专区、所有专区
     */
    private String availableRange;

    /**
     *  使用范围：指定门店、所有门店（若选择所有门店则可以指定哪些门店不可用）
     */
    private String useRange;


}
