package com.rocogz.syy.equity.entity.userCoupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户券操作日志 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-23 12:35:45</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_user_coupon_operate_log")
public class EquityUserCouponOperateLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户券编号
     */
    private String userCouponCode;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 操作结果：FROZEN-冻结，CANCEL-作废，CHANGEDATE-调整有效期 
     */
    private String operateResult;

    /**
     * 备注
     */
    private String remark;

    /**
     * 操作人
     */
    private String createUser;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;


}
