package com.rocogz.syy.equity;

/**
 * <dl>
 * <dd>Description: 权益常量类 Service</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-10 17:35:43</dd>
 * <dd>@author：Andy</dd>
 * <description>
 *     1：Andy 2020-08-14 09:54:05 将重复的值提取为COMMON_FLAG前缀，不同变量名称相同值的其他常量值在运行稳定后会删除
 * </description>
 * </dl>
 */
public final class EquityConstants {

	public static final String EMPTY_MESSAGE = "不能为空";

	/** 优惠券不限张数 **/
	public static final Integer COUPON_UNLIMIT_QUANTITY = 999999999;

	/** 一键领券输入错误车牌的返回码 **/
	public static final String RECEIVE_EMPTY_USER_COUPON_CODE = "900000";

	/** 数据库字段**/
	public static final String CREATE_TIME_COLUMN = "create_time";

	/** sql日期函数中日期格式**/
	public static final String SQL_DATE_ICON = "'%Y-%m-%d'";

	public static final String SQL_DATE_FUNCTION = "date_format(%s, %s)";

	/** 数据库日期函数大于等于 **/
	public static final String SQL_DATE_FUNCTION_START = SQL_DATE_FUNCTION + " >= {0}";

	/** 数据库日期函数小于等于 **/
	public static final String SQL_DATE_FUNCTION_END = SQL_DATE_FUNCTION + " <= {0}";

	/** 批量插入行数 **/
	public static final Integer BATCH_INSERT_ROW = 3000;

	/** 次数的默认值:0（用户券使用次数、重试次数**/
	public static final Integer DEFAULT_QUANTITY_ZERO = 0;

	/** 用户券次数-总次数、可用次数**/
	public static final Integer USER_COUPON_TOTAL_AND_AVAILABLE_QUANTITY = 1;

	/** 油卡系统操作用户标识 **/
	public static final String OIL_SYSTEM_USER = "system";

	/** ROCO车服操作用户标识 **/
	public static final String ROCO_SYSTEM_USER = "admin";

	/** 油卡用户券 **/
	public static final String OIL_USER_COUPON = "OIL_USER_COUPON";

	/** 服务券 **/
	public static final String SERVICE_COUPON = "SERVICE";

	/** 加油代金券 **/
	public static final String OIL_CASH_COUPON = "OIL_CASH";

	/** 电子兑换券 **/
	public static final String OIL_CARD_COUPON = "OIL_CARD";

	/** 公共标志:否 **/
	public static final String COMMON_FLAG_N = "N";

	/** 公共标志:是 **/
	public static final String COMMON_FLAG_Y = "Y";

	/** 公共标志：失败 **/
	public static final String COMMON_FLAG_FAIL = "FAIL";

	/** 公共标志：已使用 **/
	public static final String COMMON_FLAG_USED = "USED";

	/** 公共标志：已处理/已通知**/
	public static final String COMMON_FLAG_PROCESS = "PROCESS";

	/** 公共标志：新增/创建**/
	public static final String COMMON_FLAG_ADD = "ADD";

	/** 公共标志：取消/作废/注销 **/
	public static final String COMMON_FLAG_CANCEL = "CANCEL";

	/** 公共标志：冻结 **/
	public static final String COMMON_FLAG_FROZEN = "FROZEN";

	/** 公共标志：已过期/已失效 **/
	public static final String COMMON_FLAG_INVALID = "INVALID";

	/** 公共标志：启用 **/
	public static final String COMMON_FLAG_OPEN = "OPEN";

	/** 公共标志：停用 **/
	public static final String COMMON_FLAG_LOCK = "LOCK";

	/** 公共标志：转赠中 **/
	public static final String COMMON_FLAG_TRANSFER = "TRANSFER";

	/** 即将过期 **/
	public static final String WILL_EXPIRE = "WILL_EXPIRE";

	/** 全部：代表优惠券状态全部，所有门店可用，所有专区可用等等 **/
	public static final String STATUS_ALL = "ALL";

	/** 优惠券状态-上架**/
	public static final String COUPON_STATUS_TO_LIST = "TO_LIST";

	/** 优惠券状态-草稿**/
	public static final String COUPON_STATUS_DRAFT = "DRAFT";

	/** 申请单状态-申请单提交中**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_IN_SUBMIT = "IN_SUBMIT";

	/** 申请单状态-处理中**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_IN_PROCESS = "IN_PROCESS";

	/** 申请单状态-待处理**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_PENDING = "PENDING";

	/** 申请单状态-不通过**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_DISAGREE = "DISAGREE";

	/** 申请单状态-再次处理**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_AGAIN = "AGAIN";

	/** 申请单状态-部分失败**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_SOME_FAIL = "SOME_FAIL";

	/** 申请单状态-异常**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_ABNORMAL = "ABNORMAL";

	/** 申请单清单状态-初始**/
	public static final String BATCH_DISTRIBUTION_APPLY_DETAIL_STATUS_INIT = "INIT";

	/** 申请单清单状态-初始-失败**/
	public static final String BATCH_DISTRIBUTION_APPLY_DETAIL_STATUS_INIT_FAIL = "INIT_FAIL";

	/** 申请单公共状态-成功**/
	public static final String BATCH_DISTRIBUTION_COMMON_STATUS_SUCCESS = "SUCCESS";

	/** 申请单日期状态-已通过 **/
	public static final String BATCH_DISTRIBUTION_LOG_STATUS_PASS = "PASS";

	/** 优惠券投放信息中公共日期模式-领取既（生效/失效） **/
	public static final String COUPON_LAUNCH_INFO_DATE_NOW = "NOW";

	/** 优惠券投放信息中公共日期模式-领取后XX天（生效/失效） **/
	public static final String COUPON_LAUNCH_INFO_DATE_MODEL_LAST_DAY = "LAST_DAY";

	/** 优惠券投放信息中公共日期模式-指定日期（生效/失效） **/
	public static final String COUPON_LAUNCH_INFO_DATE_MODEL_POINT_DATE = "POINT_DATE";

	/** 优惠券投放信息中公共日期模式-根据保单有效期计算（生效/失效） **/
	public static final String COUPON_LAUNCH_INFO_DATE_MODEL_POLICY_DATE = "POLICY_DATE";

	/** 优惠券投放信息中订单失效-与优惠券失效日期相同 **/
	public static final String COUPON_LAUNCH_INFO_COUPON_INVALID = "COUPON_INVALID";

	/** 优惠券投放信息中订单失效-优惠券失效后XX天（失效） **/
	public static final String COUPON_LAUNCH_INFO_COUPON_LAST_DAY_INVALID = "COUPON_LAST_DAY_INVALID";

	/** 用户券状态-去兑换标志 **/
	public static final String USER_COUPON_STATUS_EXCHANGE = "EXCHANGE";

	/** 用户券状态-未生效 **/
	public static final String USER_COUPON_STATUS_UN_EFFECTIVE = "UN_EFFECTIVE";

	/** 用户券状态-正常/待使用 **/
	public static final String USER_COUPON_STATUS_NORMAL = "NORMAL";

	/** 用户券发放模式-批量发放 **/
	public static final String USER_COUPON_GRANT_MODEL_BATCH = "BATCH";

	/** 用户券发放模式-会员领取 **/
	public static final String USER_COUPON_GRANT_MODEL_RECEIVE = "RECEIVE";

	/** 用户券发放模式-接口发放 **/
	public static final String USER_COUPON_GRANT_MODEL_INTERFACE = "INTERFACE";

	/** 用户券发放模式-投保礼发放 **/
	public static final String USER_COUPON_GRANT_MODEL_INSURANCE_GIFT = "INSURANCE_GIFT";

	/** 用户券操作日志-调整有效期 **/
	public static final String USER_COUPON_OPERATE_LOG_CHANGEDATE = "CHANGEDATE";

	/** 用户券操作日志-退还 **/
	public static final String USER_COUPON_OPERATE_LOG_RETURN = "RETURN";

	/** 平台（投放平台/使用平台）-SYY **/
	public static final String PLATFORM_CODE_SYY = "SYY";

	/** 平台（投放平台/使用平台）-OIL **/
	public static final String PLATFORM_CODE_OIL = "OIL";

	/** 用户券使用方式：SYSTEM-系统（前端正常使用）,MANUAL-后台手工补消耗 **/
	public static final String USER_COUPON_USE_WAY_SYSTEM = "SYSTEM";

	/** 油卡请求发券状态及回调状态-初始,此状态标识券未发放成功 **/
	public static final String OIL_CARD_STATUS_INIT = "INIT";

	/** 油卡请求操作类型-退回 **/
	public static final String OIL_CARD_REQUEST_OPERATE_TYPE_BACK = "BACK";

	/** 通知油卡结果状态-异常 **/
	public static final String CALL_OIL_CARD_RESULT_STATUS_ABNORMAL = "ABNORMAL";

	/** 油卡用户券状态-充值中 **/
	public static final String OIL_CARD_USER_COUPON_IN_EXCHANGE = "IN_EXCHANGE";

	/** MQ 相关 **/
	/** 权益服务公共MQ交换器 **/
	public static final String EQUITY_MQ_COMMON_EXCHANGES = "EQUITY_COMMON_EXCHANGES";

	/** 权益服务-油卡发券-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_OIL_CARD_USER_COUPON = "EQUITY_OIL_CARD_USER_COUPON";

	/** 权益服务-发券结果通知-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_OIL_CARD_RESULT_CALL = "EQUITY_OIL_CARD_RESULT_CALL";

	/** 权益服务-领取结果通知-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_RECEIVE_RESULT_CALL = "EQUITY_OIL_CARD_RECEIVE_RESULT_CALL";

	/** 权益服务-充值-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_OIL_CARD_EXCHANGE = "EQUITY_OIL_CARD_EXCHANGE";

	/** 权益服务-充值结果-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_OIL_CARD_EXCHANGE_RESULT = "EQUITY_OIL_CARD_EXCHANGE_RESULT";

	/** 权益服务-更新优惠券发放数量-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_UPDATE_COUPON_GRANT_NUMBER = "EQUITY_UPDATE_COUPON_GRANT_NUMBER";

	/** 权益服务-发放用户券后给客户发送系统消息-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_GRANT_COUPON_SEND_MESSAGE = "EQUITY_GRANT_COUPON_SEND_MESSAGE";

	/** 服务券消耗锁key **/
	public static final String COUPON_CONSUME_LOCK_KEY_SERVICE = "SERVICE_";

	/** 代金券消耗锁key **/
	public static final String COUPON_CONSUME_LOCK_KEY_OILCASH = "OILCASH_";

	/** 电子兑换券名称 **/
	public static final String OIL_CARD_COUPON_NAME = "电子兑换券";

	/**	积分账户类型：大诚积分 **/
	public static final String POINT_ACCOUNT_TYPE_ROCO = "ROCO_POINT";

	/**	可用专区：指定专区 **/
	public static final String AVAILABLE_AREA_POINT_AREA ="POINT_AREA";

	/**	可用门店：指定门店 **/
	public static final String AVAILABLE_STORE_POINT_STORE ="POINT_STORE";


	// 待删除的常量 Andy 2020-08-14 10:44:06
//	/** 用户券显示标志-Y显示 **/
//	public static final String USER_COUPON_SHOW_FLAG = "Y";
//	/** 失败 **/
//	public static final String OIL_CARD_RESULT_STATUS_FAIL = "FAIL";
//	/** 申请单公共状态-失败**/
//	public static final String BATCH_DISTRIBUTION_COMMON_STATUS_FAIL = "FAIL";
//	/** 通知油卡结果状态-通知失败 **/
//	public static final String CALL_OIL_CARD_RESULT_STATUS_FAIL = "FAIL";
//	/** 已使用/已消耗 **/
//	public static final String USER_COUPON_STATUS_USED = "USED";
//	/** 油卡用户券状态-已兑换（已使用） **/
//	public static final String OIL_CARD_USER_COUPON_STATUS_USED = "USED";
//	/** 申请单状态-已处理**/
//	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_PROCESS = "PROCESS";
//	/** 通知油卡结果状态-已通知 **/
//	public static final String CALL_OIL_CARD_RESULT_STATUS_PROCESS = "PROCESS";
//	/** 新增/创建 **/
//	public static final String OIL_CARD_REQUEST_OPERATE_TYPE_ADD = "ADD";
//	/** 申请单状态-作废**/
//	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_CANCEL = "CANCEL";
//	/** 已作废/已取消 **/
//	public static final String USER_COUPON_STATUS_CANCEL = "CANCEL";
//	/** 油卡请求操作类型-作废 **/
//	public static final String OIL_CARD_REQUEST_OPERATE_TYPE_CANCEL = "CANCEL";
//	/** 已冻结 **/
//	public static final String USER_COUPON_STATUS_FROZEN = "FROZEN";
//	/** 已过期/失效 **/
//	public static final String USER_COUPON_STATUS_INVALID = "INVALID";
//	/** 优惠券类型状态-启用 **/
//	public static final String COUPON_TYPE_STATUS_OPEN = "OPEN";


	//huhl添加为了数据权限管理时获取到发放主体所有记录时，根据equity_issuing_body 中type进行分组，所以如果添加新的类型时最好是也要通知我
	/**
	 * 发放主体-发放机构
	 */
	 public static final String EQUITY_ISSUING_BODY_TYPE_ROCO_ORG="ROCO_ORG";
	/**
	 * 发放主体-平台商户
	 */
	public static final String EQUITY_ISSUING_BODY_TYPE_BUSINESS="BUSINESS";
	/**
	 *发放主体-合作企业
	 */
	public static final String EQUITY_ISSUING_BODY_TYPE_ENTERPRISE="ENTERPRISE";

	/**
	 * 转赠记录的状态
	 */
	public static class BestowRecordStatus {
		public static final String TYPE_CODE = "BESTOW_STATUS";
		public static final String PENDING_PAY = "PENDING_PAY";
		public static final String UN_RECEIVE = "UN_RECEIVE";
		public static final String RECEIVED = "RECEIVED";
		public static final String REVERT = "REVERT";
		public static final String REFUSE = "REFUSE";
		public static final String RECEIVE_TIME_OUT = "RECEIVE_TIME_OUT";
		public static final String CANCEL = "CANCEL";
	}

	/**
	 * 转赠记录的物品的类型
	 */
	public static class BestowRecordType {
		public static final String TYPE_CODE = "BESTOW_TYPE";
		public static final String USER_COUPON = "USER_COUPON";
		public static final String SERVICE_COUPON = "SERVICE_COUPON";
		public static final String STORE_SERVICE = "STORE_SERVICE";
		public static final String CASH_COUPON = "CASH_COUPON";
		public static final String POINT = "POINT";
		public static final String GOODS = "GOODS";
		public static final String MIX = "MIX";
	}

	/**
	 * 转赠记录的物品的类型
	 */
	public static class BestowRecordServiceType {
		public static final String TYPE_CODE = "BESTOW_SERVICE_TYPE";
		public static final String CAR_OWNER_USER_BESTOW = "CAR_OWNER_USER_BESTOW";
		public static final String CAR_OWNER_AGENT_USER_INSURANCE_GIFT = "CAR_OWNER_AGENT_USER_INSURANCE_GIFT";
		public static final String STORE_USER_INSURANCE_GIFT = "STORE_USER_INSURANCE_GIFT";
		public static final String STORE_USER_GRANT_COUPON = "STORE_USER_GRANT_COUPON";
	}

	/**
	 * 转赠记录编码放号器
	 */
	public static final String BESTOW_RECORD_CODE_SEQ = "BESTOW_CODE";


	/** =============> 下面是 转赠记录 支付超时 自动取消队列 rabbit mq 常量 */
	public static final String EQUITY_BESTOW_EXCHANGE = "EQUITY_BESTOW_EXCHANGE";
	public static final String EQUITY_BESTOW_CASH_PAY_ROUTE_KEY = "BESTOW_CASH_PAY_ROUTE_KEY";
	/** 所有需要现金支付的转赠记录都会到这个队列里去，消息过期时间30分钟，过期后回到下面的死信队列里 */
	public static final String EQUITY_BESTOW_CASH_PAY_QUEUE = "EQUITY_BESTOW_CASH_PAY_QUEUE";
	public static final String EQUITY_BESTOW_CASH_PAY_TIME_OUT_ROUTE_KEY = "BESTOW_CASH_PAY_TIME_OUT_ROUTE_KEY";
	public static final String EQUITY_BESTOW_CASH_PAY_TIME_OUT_QUEUE = "EQUITY_BESTOW_CASH_PAY_TIME_OUT_QUEUE";

	private EquityConstants() {
	}

}
