package com.rocogz.syy.equity.entity.oilCardUserCoupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 大诚电子加油券-油卡请求信息记录 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-30 14:25:41</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_oil_card_user_coupon_request_record")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityOilCardUserCouponRequestRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    private String oilOrderCode;

    /**
     * 订单金额
     */
    private BigDecimal orderAmount;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码
     */
    private String idCard;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 承保机构
     */
    private String policyOrgCode;

    /**
     * 产品编码
     */
    private String productCode;

    /**
     * 处理状态
     */
    private String status;

    /**
     * 优惠券类型：SERVICE：服务券，OIL_CASH：代金券，OIL_CARD：电子券
     * @description Andy 2020-06-30 21:56:46
     */
    private String couponType;

    /**
     * 机构编号
     * @description Andy 2020-06-30 21:56:46
     */
    private String orgCode;

    /**
     * 发放机构号（由orgCode转换而来）
     */
    private String sourceCode;

    /**
     * 是否领取验证：Y-是，N-否
     */
    private String isReceiveVerify;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 用户券兑换码
     */
    @TableField(exist = false)
    private String redeemCode;

}
