package com.rocogz.syy.equity;

import com.rocogz.util.DateUtil;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 权益工具类 </dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-05-12 08:48:46</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
public class EquityCommonUtil {

    /**
     * 获取日期
     * @param model 模式
     * @param modeVal 值
     * @param type E:生效, I:失效
     * @description 备注：如果传入的model不是 POLICY_DATE则 pointDate传入null
     * @return
     */
    public static LocalDateTime getEffectiveInvalidDateByMode(String model, String modeVal, String type, LocalDate pointDate){
        LocalDateTime localDateTime = null;
        if(EquityConstants.COUPON_LAUNCH_INFO_DATE_NOW.equals(model)){   //领取即生效
            localDateTime = DateUtil.formatDateStrToLocalDateTime(LocalDate.now().toString() + DateUtil.START_TIME);
        }else if(EquityConstants.COUPON_LAUNCH_INFO_DATE_MODEL_POINT_DATE.equals(model)){ //指定日期
            localDateTime = DateUtil.formatDateStrToLocalDateTime(modeVal + (type == "E" ? DateUtil.START_TIME : DateUtil.END_TIME ));
        }else if(EquityConstants.COUPON_LAUNCH_INFO_DATE_MODEL_LAST_DAY.equals(model)){//领取后几天生效
            localDateTime = DateUtil.formatDateStrToLocalDateTime(LocalDate.now().plusDays(Long.valueOf(modeVal)) + (type == "E" ? DateUtil.START_TIME : DateUtil.END_TIME));
        }else if(EquityConstants.COUPON_LAUNCH_INFO_DATE_MODEL_POLICY_DATE.equals(model)){  //保单日期XX天生效/失效
            localDateTime = DateUtil.formatDateStrToLocalDateTime(pointDate.plusDays(Long.valueOf(modeVal)) + (type == "E" ? DateUtil.START_TIME : DateUtil.END_TIME));
        }
        return localDateTime;
    }

    /**
     *  根据订单失效期方式、订单失效期值、用户券失效日期计算订单失效日期
     * @param orderInvalidModel 订单失效期方式
     * @param orderInvalidValue 订单失效期值
     * @param userCouponInvalidDate 用户券失效日期
     * @return
     */
    public static LocalDateTime getOrderInvalidDate(String orderInvalidModel, String orderInvalidValue, LocalDateTime userCouponInvalidDate){
        if(EquityConstants.COUPON_LAUNCH_INFO_COUPON_LAST_DAY_INVALID.equals(orderInvalidModel)){ //优惠券失效日期XX天后失效
            return userCouponInvalidDate.plusDays(Long.valueOf(orderInvalidValue));
        }
        return userCouponInvalidDate;
    }
}
