package com.rocogz.syy.equity.dto.equity.batchDistributionApply;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户券短信发放信息统计 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-02-23 16:46:49</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class UserCouponSendMessageStatisticDto extends IdEntity {

    /**
     * 发放主体
     */
    private String sourceName;

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 发放次数
     */
    private Integer sendQuantity;

    /**
     * 发放总次数
     */
    private Integer totalSendQuantity;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 业务单发放时间
     */
    private LocalDateTime createTime;

    /**
     * 短信发放日期
     */
    private LocalDate messageDate;

    /**
     * 短信发放时间
     */
    private LocalDateTime messageTime;

    /**
     * 短信发放时段：AM-上午，PM-下午，NIGHT-晚上
     */
    private String timeRegion;

    /**
     * 申请单总人数
     */
    private Integer totalPerson;

    /**
     * 发放人数
     */
    private Integer quantity;

    /**
     * 本条短信转化的客户领取数量
     */
    private Integer receiveQuantity;

    /**
     * 本条短信客户领取转化率
     */
    private BigDecimal receiveRate;

    /**
     * 本条短信的总客户领取转化率
     */
    private BigDecimal totalReceiveRate;

    /**
     * 报表统计时间
     */
    private LocalDateTime reportTime;

    /**
     * 本次短信距上次短信间隔
     */
    private String intevalBefore;

}
