package com.rocogz.syy.equity.dto.equity.batchDistributionApply;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 用户券短信发放信息统计查询参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-02-23 16:46:49</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class UserCouponSendMessageStatisticParamDto extends IdEntity {

    /**
     * 发放主体
     */
    private List<String> sourceCodeList;

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 业务单发放开始日期
     */
    private String applyStartDate;

    /**
     * 业务单发放结束日期
     */
    private String applyEndDate;

    /**
     * 短信发放开始日期
     */
    private LocalDate messageStartDate;

    /**
     * 短信发放结束日期
     */
    private LocalDate messageEndDate;

    /**
     * 短信发放时段：AM-上午，PM-下午，NIGHT-晚上
     */
    private String timeRegion;

    /**
     * 排序字段
     */
    private String sortField;

    /**
     * 排序规则：ASC，DESC
     */
    private String sortType;

    /**
     * 页码
     */
    private int page;

    /**
     * 每页记录数
     */
    private int limit;


}
