package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.entity.issuingBody.IssuingBody;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 批量发券审核规则配置 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2021-01-23 17:50:04</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_apply_limit_config")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionApplyLimitConfig extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编号
     */
    private String code;

    /**
     * 类型：数量规则：QUANTITY_RULE
     */
    private String type;

    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 限制数量
     */
    private Integer limitQuantity;

    /**
     * 状态：启用，停用
     */
    private String status;

    /**
     * 已发放发放张数
     */
    @TableField(exist = false)
    private Integer tmpGrantQuantity;

    /**
     * 发放主体
     */
    @TableField(exist = false)
    private IssuingBody issuingBody;

}
