package com.rocogz.syy.equity.entity.bestow;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 权益中心-转赠记录
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_bestow_record")
public class EquityBestowRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 转赠记录编号
     */
    private String code;

    /**
     * 转赠渠道
     */
    private String bestowChannel;

    /**
     * 业务类型
     */
    private String serviceType;

    /**
     * 转赠人的用户编码
     */
    private String senderUserCode;

    /**
     * 转赠人的手机号码
     */
    private String senderUserMobile;

    /**
     * 转赠人的openid
     */
    private String senderUserOpenid;

    /**
     * 接受者手机号
     */
    private String receiverMobile;

    /**
     * 接受者姓名(发券时填写的).
     */
    private String receiverName;

    /**
     * 赠送物品类型(COUPON:券;POINT:积分;GOODS:物品)
     */
    private String type;

    /**
     * 赠送的状态(UN_RECEIVE:待领取;RECEIVED:已领取;REVERT:已撤回;REFUSE:拒绝领取;TIME_OUT:超时退回)
     */
    private String status;

    /**
     * 赠送物品的数量
     */
    private Integer amount;

    /**
     * 赠送的为积分时，积分的数量
     */
    private Integer pointAmount;

    /**
     * 套餐名称
     */
    private String mixName;

    /**
     * 套餐数量
     */
    private Integer mixAmount;

    /**
     * 接受者领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 备注
     */
    private String remark;

    /**
     * 小程序appid.
     */
    private String miniAppid;

    /**
     * 小程序名称.
     */
    @TableField(exist = false)
    private String miniAppName;

    /**
     * 所属服务平台名称.
     */
    @TableField(exist = false)
    private String servicePlatformName;

    /**
     * 转赠内容List
     */
    @TableField(exist = false)
    private List<EquityBestowRecordItem> itemList;

    /**
     * 赠送类型名称
     */
    @TableField(exist = false)
    private String typeLabelName;

    /**
     * 赠送记录状态名称
     */
    @TableField(exist = false)
    private String statusLabelName;

    /**
     * 赠送人的头像url
     */
    @TableField(exist = false)
    private String senderAvatarUrl;
}
