package com.rocogz.syy.equity.entity.issuingBody;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.dto.issuingBody.EquityIssuingBodyAssociatedDto;
import com.rocogz.syy.equity.dto.issuingBody.IssuingBodyRoleDto;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 发放主体
 * </p>
 *
 * @author yinshihao
 * @since 2020-04-08
 */
@TableName(value = "equity_issuing_body")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class IssuingBody extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 主体类型(目前分为三种:人保机构 ROCO_ORG, 合作企业 ENTERPRISE, 平台商户 BUSINESS)
     */
    private String type;

    /**
     * 父级主体编码,父级主体编码为0的为顶级主体
     */
    private String pCode;

    /**
     * 主体等级(默认顶级为1级,其子级为2级,以此类推)
     */
    private Integer level;

    /**
     * 主体编码
     */
    private String code;

    /**
     * 主体名称
     */
    private String name;

    /**
     * 关联主体编码 (当主体类型是人保机构时代表机构编码,是合作企业时代表社会信用代码,是平台商户时代表平台商户编码)
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String linkedBodyCode;

    /**
     * 关联主体名称 (当主体类型是人保机构时代表机构名称,是合作企业时代表企业名称,是平台商户时此项为空)
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String linkedBodyName;

    /**
     * 简称(人保机构和合作企业才有)
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String abbreviation;

    /**
     * 说明(只有合作企业才有)
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String description;

    /**
     * 状态(分为OPEN/LOCK)
     */
    private String status;

    /**
     * 小程序appid
     */
    private String miniAppid;

    /**
     * 小程序名称
     */
    @TableField(exist = false)
    private String miniName;

    /**
     * 发放主体性质
     */
    private String whetherCustomer;

    /**
     * 合作客户编码
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String customerCode;

    /**
     * 合作客户简称
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String customerAbbreviation;

    /**
     * 发放主体关联平台专区信息
     */
    @TableField(exist = false)
    private List<EquityIssuingBodyAssociatedDto> associatedDto;

    /**
     * 关联角色id列表
     */
    @TableField(exist = false)
    private List<Integer> roleIdList;

    /**
     * 关联角色列表
     */
    @TableField(exist = false)
    private List<IssuingBodyRoleDto> roleList;

}
