/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.equity;

import com.rocogz.util.DateUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;

public class EquityCommonUtil {
    public static LocalDateTime getEffectiveInvalidDateByMode(String model, String modeVal, String type, LocalDate pointDate) {
        LocalDateTime localDateTime = null;
        if ("NOW".equals(model)) {
            localDateTime = DateUtil.formatDateStrToLocalDateTime((String)(LocalDate.now().toString() + " 00:00:00"));
        } else if ("POINT_DATE".equals(model)) {
            localDateTime = DateUtil.formatDateStrToLocalDateTime((String)(modeVal + (type == "E" ? " 00:00:00" : " 23:59:59")));
        } else if ("LAST_DAY".equals(model)) {
            localDateTime = DateUtil.formatDateStrToLocalDateTime((String)(LocalDate.now().plusDays(Long.valueOf(modeVal)) + (type == "E" ? " 00:00:00" : " 23:59:59")));
        } else if ("POLICY_DATE".equals(model)) {
            localDateTime = DateUtil.formatDateStrToLocalDateTime((String)(pointDate.plusDays(Long.valueOf(modeVal)) + (type == "E" ? " 00:00:00" : " 23:59:59")));
        }
        return localDateTime;
    }

    public static LocalDateTime getOrderInvalidDate(String orderInvalidModel, String orderInvalidValue, LocalDateTime userCouponInvalidDate) {
        if ("COUPON_LAST_DAY_INVALID".equals(orderInvalidModel)) {
            return userCouponInvalidDate.plusDays(Long.valueOf(orderInvalidValue));
        }
        return userCouponInvalidDate;
    }
}

