package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDate;

/**
 * <dl>
 * <dd>Description: 批量发券申请单清单 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-14 21:23:54</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_coupon_apply_detail")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionCouponApplyDetail extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    private String couponName;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 姓名
     */
    private String name;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码
     */
    private String idCard;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 状态：INIT-初始，SUCCESS-成功，FAIL-失败
     */
    private String status;

    /**
     * 发放数量
     */
    private Integer quantity;

    /**
     * 此数据在文件内行数
     */
    private Integer rowNum;

    /**
     * 生效日期
     */
    private LocalDate effectiveDate;

    /**
     * 失效日期
     */
    private LocalDate invalidDate;

    /**
     * 备注
     */
    private String rmk;


}
