package com.rocogz.syy.equity.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 优惠券专区项目关系表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-06 12:13:09</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_coupon_area_project_rel")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityCouponAreaProjectRel extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 服务分类编号
     */
    private String serviceCataCode;

    /**
     * 服务分类名称
     */
    private String serviceCataName;

    /**
     * 专区项目编号
     */
    private String areaProjectCode;

    /**
     * 专区项目名称
     */
    private String areaProjectName;

    /**
     * 服务项目编号
     */
    private String serviceProjectCode;

    /**
     * 服务项目名称
     */
    private String serviceProjectName;


}
