package com.rocogz.syy.equity.entity.oilCardPointAccount;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 电子兑换券积分账户 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-08-13 17:42:35</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_oil_card_point_account")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityOilCardPointAccount extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 账号
     */
    private String code;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * openid
     */
    private String openId;

    /**
     * 会员编号
     */
    private String userCode;

    /**
     * 账户类型
     */
    private String type;

    /**
     * 总额度
     */
    private BigDecimal totalAmount;

    /**
     * 可用额度
     */
    private BigDecimal availableAmount;

    /**
     * 已用额度
     */
    private BigDecimal useAmount;

    /**
     * 已过期额度
     */
    private BigDecimal invalidAmount;

    /**
     * 作废额度
     */
    private BigDecimal cancelAmount;

    /**
     * 冻结额度
     */
    private BigDecimal frozenAmount;

    /**
     * 状态:OPEN-正常，LOCK-锁定，CANCEL-注销
     */
    private String status;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
