package com.rocogz.syy.equity.entity.oilCardUserCoupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 电子加油券消耗记录 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-06-01 21:30:41</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_oil_card_user_coupon_consume")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityOilCardUserCouponConsume extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户券编号
     */
    private String userCouponCode;

    /**
     * 使用平台
     */
    private String platformCode;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单金额
     */
    private BigDecimal orderAmount;

    /**
     * 备注
     */
    private String rmk;

    /**
     * 删除标记（留作扩展，如果存在已退还的用户券则此记录标识为Y）
     */
    private String deleteFlag;

    /**
     * 使用时间
     */
    private LocalDateTime createTime;


}
