package com.rocogz.syy.equity;

import com.rocogz.util.DateUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/**
 * <dl>
 * <dd>Description: 权益工具类 </dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-05-12 08:48:46</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
public class EquityCommonUtil {

    /**
     * 获取日期
     * @param model 模式
     * @param modeVal 值
     * @param type E:生效, I:失效
     * @description 备注：如果传入的model不是 POLICY_DATE则 pointDate传入null
     * @return
     */
    public static LocalDateTime getEffectiveInvalidDateByMode(String model, String modeVal, String type, LocalDate pointDate){
        LocalDateTime localDateTime = null;
        if(EquityConstants.COUPON_LAUNCH_INFO_DATE_NOW.equals(model)){   //领取即生效
            localDateTime = DateUtil.formatDateStrToLocalDateTime(LocalDate.now().toString() + DateUtil.START_TIME);
        }else if(EquityConstants.COUPON_LAUNCH_INFO_DATE_MODEL_POINT_DATE.equals(model)){ //指定日期
            localDateTime = DateUtil.formatDateStrToLocalDateTime(modeVal + (type == "E" ? DateUtil.START_TIME : DateUtil.END_TIME ));
        }else if(EquityConstants.COUPON_LAUNCH_INFO_DATE_MODEL_LAST_DAY.equals(model)){//领取后几天生效
            localDateTime = DateUtil.formatDateStrToLocalDateTime(LocalDate.now().plusDays(Long.valueOf(modeVal)) + (type == "E" ? DateUtil.START_TIME : DateUtil.END_TIME));
        }else if(EquityConstants.COUPON_LAUNCH_INFO_DATE_MODEL_POLICY_DATE.equals(model)){  //保单日期XX天生效/失效
            localDateTime = DateUtil.formatDateStrToLocalDateTime(pointDate.plusDays(Long.valueOf(modeVal)) + (type == "E" ? DateUtil.START_TIME : DateUtil.END_TIME));
        }
        return localDateTime;
    }

    /**
     *  根据订单失效期方式、订单失效期值、用户券失效日期计算订单失效日期
     * @param orderInvalidModel 订单失效期方式
     * @param orderInvalidValue 订单失效期值
     * @param userCouponInvalidDate 用户券失效日期
     * @return
     */
    public static LocalDateTime getOrderInvalidDate(String orderInvalidModel, String orderInvalidValue, LocalDateTime userCouponInvalidDate){
        if(EquityConstants.COUPON_LAUNCH_INFO_COUPON_LAST_DAY_INVALID.equals(orderInvalidModel)){ //优惠券失效日期XX天后失效
            return userCouponInvalidDate.plusDays(Long.valueOf(orderInvalidValue));
        }
        return userCouponInvalidDate;
    }

    /**
     * 根据传入小时计算所在时间段（上午、下午、晚上）
     * @param hour
     * @return
     */
    public static String convertTimeInRegion(Integer hour){
        if(hour >= 0 && hour < 12){
            return EquityConstants.COMMON_FLAG_AM;
        }else if(hour >= 12 && hour < 18){
            return EquityConstants.COMMON_FLAG_PM;
        }else {
            return EquityConstants.COMMON_FLAG_NIGHT;
        }
    }

    /**
     * 首位截取
     * @param param 参数
     * @param value 位数
     * @return
     */
    private static String beforeSplit(String param, String value){
        if(param.length() <= Integer.parseInt(value)){
            return param;
        }else {
            return param.substring(0, Integer.parseInt(value));
        }
    }

    /**
     * 后位截取
     * @param param 参数
     * @param value 位数
     * @return
     */
    private static String afterSplit(String param, String value){
        if(param.length() <= Integer.parseInt(value)){
            return param;
        }else {
            return param.substring(param.length() - Integer.parseInt(value), param.length());
        }
    }

    /**
     * 生成规则签名
     * @param ruleMap   规则
     * @param name      姓名
     * @param mobile    手机号
     * @param licenseNo 车牌号
     * @return
     */
    public static String generateRuleSigna(Map<String, String> ruleMap, String name, String mobile, String licenseNo){
        MultiValueMap multiValueMap = new LinkedMultiValueMap();
        for(Map.Entry<String, String> entry : ruleMap.entrySet()){
            if(EquityConstants.RECEIVE_RULE_NAME.equals(entry.getKey()) && StringUtils.isNotBlank(name)){
                multiValueMap.add(entry.getKey(), EquityConstants.COMMON_FLAG_Y.equals(entry.getValue()) ? name : "");
            }
            if(EquityConstants.RECEIVE_RULE_MOBILE_BEFORE_N.equals(entry.getKey()) && StringUtils.isNotBlank(mobile)){
                multiValueMap.add(entry.getKey(), beforeSplit(mobile, entry.getValue()));
            }
            if(EquityConstants.RECEIVE_RULE_MOBILE_AFTER_N.equals(entry.getKey()) && StringUtils.isNotBlank(mobile)){
                multiValueMap.add(entry.getKey(), afterSplit(mobile, entry.getValue()));
            }
            if(EquityConstants.RECEIVE_RULE_CARNUMBER_AFTER_N.equals(entry.getKey()) && StringUtils.isNotBlank(licenseNo)){
                multiValueMap.add(entry.getKey(), afterSplit(licenseNo, entry.getValue()));
            }
        }
        return signatureStr(multiValueMap);
    }

    /**
     * 生成签名(前端领券使用）- 平安专用
     * @param mobile        手机号
     * @param licenseNo     车牌号
     * @param name          姓名
     * @return
     */
    public static String generateRuleSigna(String name, String mobile, String licenseNo){
        MultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.add(EquityConstants.RECEIVE_RULE_MOBILE_BEFORE_N, beforeSplit(mobile, "3"));
        multiValueMap.add(EquityConstants.RECEIVE_RULE_MOBILE_AFTER_N, afterSplit(mobile,"4"));
        multiValueMap.add(EquityConstants.RECEIVE_RULE_CARNUMBER_AFTER_N, afterSplit(licenseNo,"3"));
        multiValueMap.add(EquityConstants.RECEIVE_RULE_NAME, name);
        return signatureStr(multiValueMap);
    }

    /**
     * 生成签名字符串
     * @param parameters
     * @return
     */
    private static String signatureStr(MultiValueMap<String,String> parameters){
        StringBuilder tempStr = new StringBuilder();
        //将value放到 treeSet中排序，  采用默认排序即可
        TreeSet<String> values = new TreeSet();
        for (String key : parameters.keySet()) {
            if(StringUtils.isNotBlank(parameters.get(key).get(0))){
                values.add(parameters.get(key).get(0));
            }
        }
        // 排序并拼接参数值（按值的升序排序）
        for (String val : values) {
            tempStr.append(val);
        }
        return tempStr.toString();
    }

    /**
     * 生成规则条件SQL
     * @param confitionList     条件列表
     * @param mobile            手机号
     * @param name              姓名
     * @param licenseNo         车牌号
     * @return
     */
    public static Map<String, String> batchDetailSearchSql(List<String> confitionList, String mobile, String name, String licenseNo){
        Map<String, String> map = new HashMap<>();
        StringBuffer sql = new StringBuffer();
        StringBuffer key = new StringBuffer();
        if(CollectionUtils.isNotEmpty(confitionList)){
            if(confitionList.contains(EquityConstants.EquityBatchApplyLimitTypeRuleCondition.MOBILE)){
                sql.append(" AND detail.mobile='").append(mobile).append("'");
                key.append(mobile);
            }
            if(confitionList.contains(EquityConstants.EquityBatchApplyLimitTypeRuleCondition.NAME)){
                sql.append(" AND detail.name='").append(name).append("'");
                key.append(name);
            }
            if(confitionList.contains(EquityConstants.EquityBatchApplyLimitTypeRuleCondition.LICENSE_NO_AFTER_THREE)){
                licenseNo = licenseNo.length() >3 ? licenseNo.substring(licenseNo.length()-3, licenseNo.length()) : licenseNo;
                sql.append(" AND detail.license_no like '%").append(licenseNo).append("'");
                key.append(licenseNo);
            }
            map.put(EquityConstants.SEARCH_SQL_KEY, sql.toString());
            map.put(EquityConstants.PARAM_KEY, key.toString());
        }
        return map;
    }
}
