package com.rocogz.syy.equity.dto.equity.userCoupon;

import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 发放用户券请求参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-03-10 16:00:56</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class ScmGrantUserCouponParamDto {

    /**
     * 分销系统订单编号（全局唯一）
     */
    @NotNull(message = "明细订单编号" + EquityConstants.EMPTY_MESSAGE)
    private String orderCode;

    /**
     * 套餐明细订单编号
     */
    private String comboOrderItemCode;

    /**
     * ROCO请求申请单清单编号（业务单号）
     */
    private String applyDetailCode;

    /**
     * 发放平台
     */
    private String grantPlatform;

    /**
     * 发放方式：BATCH-批量发放，INTERFACE-接口发放，MANUAL-手工发放
     */
    private String grantWay;

    /**
     * 面值
     */
    private BigDecimal faceValue;

    /**
     * 操作用户
     */
    private String operateUser;

    /**
     * 发放主体
     */
    private String source;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 生效日期:yyyy-MM-dd 00:00:00
     */
    private LocalDate effectiveDate;

    /**
     * 失效日期:yyyy-MM-dd 23:59:59
     */
    private LocalDate invalidDate;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码明文
     */
    private String idCardExplicit;

    /**
     * 保单编号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 发券性质：BUSINESS_VERIFY:业务验证，NORMAL:正常发券
     */
    private String nature;

    /**
     * 平台产品编码
     */
    @NotNull(message = "平台产品编码" + EquityConstants.EMPTY_MESSAGE)
    private String productCode;

    /**
     * 套餐平台产品编号
     */
    private String comboProductCode;

    /**
     * 代理商产品编号
     */
    private String agentProductCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 发放规则编号
     */
    private String grantRuleCode;

    /**
     * 领取规则编号
     */
    private String receiveRuleCode;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

}
