package com.rocogz.syy.equity.entity.oilCardPointAccount;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 积分发放流水 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-10-14 18:23:29</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_oil_card_point_flow")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityOilCardPointFlow extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 业务流水号（全局唯一）
     */
    private String businessSerialNo;

    /**
     * 业务号(订单编号或其他业务号）
     */
    @NotNull
    private String businessCode;

    /**
     * 业务发生额（订单金额或其他业务额度）
     */
    @NotNull
    private BigDecimal businessAmount;

    /**
     * 业务相关用户号
     */
    private String businessUserCode;

    /**
     * 业务相关用户昵称
     */
    private String businessNickName;

    /**
     * 业务相关用户手机号
     */
    private String businessMobile;

    /**
     * 积分金额
     */
    @NotNull
    private BigDecimal pointAmount;

    /**
     * 发放类型：NORMAL:普通发放，PERSON_ORDER:个人订单，TEAM_ORDER：团队订单，TRANSFER：转赠发放， AUTHENTICATION：认证奖励，REGISTER:注册奖励
     */
    @NotNull
    private String type;

    /**
     * 发放类型：中文名称
     */
    @TableField(exist = false)
    private String typeName;

    /**
     * 发放平台
     */
    @NotNull
    private String grantPlatformCode;

    /**
     * 用户号
     */
    private String userCode;

    /**
     * 手机号
     */
    @NotNull
    private String mobile;

    /**
     * openId
     */
    private String openId;

    /**
     * 积分账户编号
     */
    private String pointAccountCode;

    /**
     * 积分账户类型: ROCO_POINT:大诚积分
     */
    @NotNull
    private String pointType;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 状态:PROCESS-已处理,CANCEL-已作废
     */
    private String status;

    /**
     * 描述
     */
    private String description;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
