package com.rocogz.syy.equity.dto.issuingBody;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.entity.issuingBody.EquityIssuingBodyContacts;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 发放主体Dto对象
 * </p>
 *
 * @author yinshihao
 * @since 2020-04-08
 */
@Data
public class IssuingBodyDto extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 主体类型(目前分为三种:人保机构 ROCO_ORG, 合作企业 ENTERPRISE, 平台商户 BUSINESS)
     */
    private String type;

    /**
     * 父级主体编码,父级主体编码为0的为顶级主体
     */
    private String pCode;

    /**
     * 父级主体名称
     */
    private String pName;

    /**
     * 主体等级(默认顶级为1级,其子级为2级,以此类推)
     */
    private Integer level;

    /**
     * 主体编码
     */
    private String code;

    /**
     * 主体名称
     */
    private String name;

    /**
     * 关联主体编码 (当主体类型是人保机构时代表机构编码,是合作企业时代表社会信用代码,是平台商户时代表平台商户编码)
     */
    private String linkedBodyCode;

    /**
     * 平台商户名称
     */
    private String businessName;

    /**
     * 关联主体名称 (当主体类型是人保机构时代表机构名称,是合作企业时代表企业名称,是平台商户时此项为空)
     */
    private String linkedBodyName;

    /**
     * 简称(人保机构和合作企业才有)
     */
    private String abbreviation;

    /**
     * 说明(只有合作企业才有)
     */
    private String description;

    /**
     * 状态(分为OPEN/LOCK)
     */
    private String status;

    /**
     * 是否存在下级(分为Y/N)
     */
    private String  existSon;

    /**
     * 类型名称(人保机构, 合作企业, 平台商户)
     */
    private String  typeName;

    /**
     * 小程序appid
     */
    private String miniAppid;

    /**
     * 小程序名称
     */
    private String miniName;

    /**
     * 发放主体性质
     */
    private String whetherCustomer;

    /**
     * 合作客户编码
     */
    private String customerCode;

    /**
     * 合作客户简称
     */
    private String customerAbbreviation;

    /**
     * 关联角色id列表
     */
    @TableField(exist = false)
    private List<Integer> roleIdList;

    /**
     * 关联角色列表
     */
    private List<IssuingBodyRoleDto> roleList;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区名称
     */
    private String districtName;

    /**
     * 区编码
     */
    private String districtCode;

    /**
     * 街道名称
     */
    private String streetName;

    /**
     * 街道编码
     */
    private String streetCode;

    /**
     * 详细地址
     */
    private String detailAddress;

    /**
     * 发放主体联系人列表
     */
    private List<EquityIssuingBodyContacts> issuingBodyContacts;

    /**
     * 电子券显示的赠送方名称
     */
    private String giverName;

    /**
     * 产品发放模式
     */
    private String productDistributionMode;

}
