package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.entity.operationLog.EquityOperationLog;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 批量发券申请单主信息 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-14 21:23:15</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_coupon_apply")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionCouponApply extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单编码
     */
    private String applyNo;

    /**
     * 平台码
     */
    private String platformCode;

    /**
     * 投放主体
     */
    private String sourceCode;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 小程序名称
     */
    @TableField(exist = false)
    private String miniAppName;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 团队名称
     */
    @TableField(exist = false)
    private String teamName;

    /**
     * 发放人数
     */
    private Integer totalPerson;

    /**
     * 发放总张数
     */
    private Integer totalQuantity;

    /**
     * 产品发放模式：AFTER_PASSING_DIRECT_DISTRIBUTION-申请通过发放，SYSTEM_CENTRALIZED_DISTRIBUTION-系统集中发放
     */
    private String productDistributionModel;

    /**
     * 发券性质：BUSINESS_VERIFY:业务验证，NORMAL：正常发券
     */
    private String nature;

    /**
     * 申请单状态(PENDING-待处理，PROCESS-已处理)
     */
    private String status;

    /**
     * 文件名称
     */
    private String fileName;

    /**
     * 文件路径
     */
    private String filePath;

    /**
     * 备注
     */
    private String rmk;

    /**
     * 短信发送次数
     */
    @TableField(exist = false)
    private Integer messageQuantity;

    /**
     * 发送短信标识
     */
    @TableField(exist = false)
    private boolean sendMessageFlag;

    /**
     * 优惠券名称
     */
    @TableField(exist = false)
    private String couponName;

    /**
     * 投放主体名称
     */
    @TableField(exist = false)
    private String sourceName;

    /**
     * 批量发券申请单清单
     */
    @TableField(exist = false)
    private List<EquityBatchDistributionCouponApplyDetail> batchDistributionDetailList;

    /**
     * 优惠券发放结果记录
     */
    @TableField(exist = false)
    private List<EquityBatchDistributionCouponResultRecord> couponResultRecordList;

    /**
     * 操作日志
     */
    @TableField(exist = false)
    private EquityOperationLog operationLog;

}
