package com.rocogz.syy.equity.entity.bestow;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * <p>
 * 权益中心-转赠的内容
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_bestow_record_item")
public class EquityBestowRecordItem extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 转赠记录编号
     */
    private String bestowRecordCode;

    /**
     * 赠送物品类型(COUPON:券;GOODS:物品)
     */
    private String itemType;

    /**
     * 赠送物品的数量
     */
    private Integer itemAmount;

    /**
     * 转赠的物品的编码, 转赠物品时为订单编号,转赠优惠券时为优惠券编号
     */
    private String itemCode;

    /**
     * 转赠的物品的名称
     */
    private String itemName;

    /**
     * 发券来源
     */
    private String itemSource;

    /**
     * 图片url
     */
    private String itemPictureUrl;

    /**
     * 发放用户券时的生效期(从发放时间往后增加指定天数).
     */
    private Integer effectiveDays;

    /**
     * 发放用户券时的有效期(从发放时间往后增加指定天数(生效期+有效期)).
     */
    private Integer validDays;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;


}
