package com.rocogz.syy.equity.entity.userCoupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户券请求第三方主信息表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2021-01-14 22:50:04</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_user_coupon_gift_info")
public class EquityUserCouponGiftInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编号
     */
    private String serialNo;

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 申请单清单编号
     */
    private String applyDetailCode;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 发放主体编号
     */
    private String sourceCode;

    /**
     * 是否套餐：Y-是，N-否
     */
    private String giftFlag;

    /**
     * 状态：INIT-初始，IN_PROCESS-处理中，PROCESS-已处理，FAIL-失败，ABNORMAL-异常
     */
    private String status;

    /**
     * 重试次数
     */
    private Integer retryQuantity;

    /**
     * 备注
     */
    private String rmk;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
