package com.rocogz.syy.equity.dto.equity.userCoupon;

import com.rocogz.syy.equity.EquityConstants;
import com.rocogz.syy.equity.entity.userCoupon.EquityUserCouponInfo;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 用户券领取请求参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-04-21 15:29:24</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class UserCouponRecieveParamDto {

    /**
     * openId
     */
    @NotNull(message = "openId" + EquityConstants.EMPTY_MESSAGE)
    private String openId;

    /**
     * 车牌号列表
     */
    private List<String> licenseNoList;

    /**
     * 绑定手机号
     */
    @NotNull(message = "绑定手机号" + EquityConstants.EMPTY_MESSAGE)
    private String bindMobile;

    /**
     * 待领取用户券列表
     */
    private List<EquityUserCouponInfo> userCouponInfoList;
}
