package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 批量发券申请单清单 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-14 21:23:54</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_coupon_apply_detail")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionCouponApplyDetail extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 申请单类型,即发放渠道
     * @see EquityConstants.DictEquityApplyType
     */
    private String applyType;

    /**
     * 服务平台
     */
    private String miniAppid;

    /**
     * 服务平台名称
     */
    @TableField(exist = false)
    private String miniAppName;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 客户编号
     */
    private String customerCode;

    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 发放主体名称
     */
    @TableField(exist = false)
    private String sourceName;

    /**
     * 清单编号
     */
    private String code;

    /**
     * 平台产品编号
     */
    private String platformProductCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 代理商产品编号
     */
    private String agentProductCode;

    /**
     * 发放规则编码
     */
    private String grantRuleCode;

    /**
     * 领取规则编码
     */
    private String receiveRuleCode;

    /**
     * 扣减时点：领取时扣减：DEDUCTION_ON_COLLECTION， 发放时扣减：DEDUCTION_ON_ISSUE
     */
    private String dedutionTimePoint;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    private String couponName;

    /**
     * 优惠券类型
     */
    @TableField(exist = false)
    private String couponTypeCode;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 姓名
     */
    private String name;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码
     */
    private String idCard;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 状态：INIT-初始，SUCCESS-成功，FAIL-失败
     */
    private String status;

    /**
     * 是否审核数据：Y-是，N-否
     */
    private String approveFlag;

    /**
     * 发放数量
     */
    private Integer quantity;

    /**
     * 已发放数量
     */
    private Integer grantQuantity;

    /**
     * 此数据在文件内行数
     */
    private Integer rowNum;

    /**
     * 扣减额度
     */
    private BigDecimal dedutionAmount;

    /** 单位面值**/
    private BigDecimal unitFaceValue;

    /**
     * 生效日期
     */
    private LocalDate effectiveDate;

    /**
     * 失效日期
     */
    private LocalDate invalidDate;

    /**
     * 备注
     */
    private String rmk;

    /**
     * 描述
     */
    private String description;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 领取状态
     */
    private String receiveStatus;

    /**
     * 面值
     */
    @TableField(exist = false)
    private BigDecimal faceValue;

    /**
     * 发放短信次数
     */
    @TableField(exist = false)
    private Integer sendMessageQuantity;

    /**
     * 注释
     */
    private String notes;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


    /**
     * 分拆的现金[B端送礼专属字段]
     */
    private BigDecimal allocatedCash;

    /**
     * 分拆的额度[B端送礼专属字段]
     */
    private BigDecimal allocatedQuota;

}
