package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.entity.coupon.EquityCouponInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 批量发券结果记录表（记录优惠券发放总数、成功数、失败数） 前端控制器 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-14 21:23:15</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_coupon_result_record")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionCouponResultRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 平台产品编号
     */
    private String platformProductCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 代理商产品编号
     */
    private String agentProductCode;

    /**
     * 产品类型
     */
    @TableField(exist = false)
    private String productType;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 发放张数
     */
    private Integer quantity;

    /**
     * 发放总张数
     */
    private Integer totalQuantity;

    /**
     * 发放成功数量
     */
    private Integer successQuantity;

    /**
     * 发放失败数量
     */
    private Integer failQuantity;

    /**
     * 作废张数
     */
    @TableField(exist = false)
    private Integer cancelQuantity;

    /**
     * 优惠券信息
     */
    @TableField(exist = false)
    private EquityCouponInfo couponInfo;

}
