package com.rocogz.syy.equity.entity.oilCardUserCoupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 积分变动流水（发放、使用、过期等所有对积分产生变动的流水）
 * </p>
 *
 * @author Andy
 * @since 2021-05-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_oil_card_point_change_flow")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityOilCardPointChangeFlow extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 积分明细编号（使用的积分无此编号，只有订单编号）
     */
    private String pointUserCouponCode;

    /**
     * 积分账户编号
     */
    private String pointAccountCode;

    /**
     * 积分变动：ADD-增加，SUBTRACT-减少
     */
    private String addSub;

    /**
     * 订单编号：使用的积分会有订单编号，过期无订单编号
     */
    private String orderCode;

    /**
     * 发生金额
     */
    private BigDecimal changeAmount;

    /**
     * 描述
     */
    private String description;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
