package com.rocogz.syy.equity.dto.equity.userCoupon;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 用户券领取结果 dto</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2021-06-07 16:42:16</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UserCouponReceiveResultDto implements Serializable {

    /**
     * 用户券编号
     */
    private String name;

    /**
     * 用户券兑换码
     */
    private String type;

    /**
     * 领取数量
     */
    private Integer receiveQuantity;

    /**
     * 领取金额
     */
    private BigDecimal receiveAmount;

    /**
     * 主体编号
     */
    private String issuingCode;

}
