package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 申请单发短信记录主信息表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2021-02-23 13:08:04</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_send_message_info")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionSendMessageInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 发放主体编号
     */
    private String sourceCode;

    /**
     * 发送类型：NORMAL：正常通知，OUT：外呼通知，BATCH：批量通知
     */
    private String sendType;

    /**
     * 申请单总人数
     */
    private Integer totalPerson;

    /**
     * 发送人数
     */
    private Integer quantity;

    /**
     * 发送次数
     */
    private Integer sendQuantity;

    /**
     * 短信类型：NOW:即时发送，QUARTZ:定时发送
     */
    private String type;

    /**
     * 参数
     */
    private String param;

    /**
     * 时段：AM-上午，PM-下午, NIGHT-晚上
     */
    private String timeRegion;

    /**
     * 操作人
     */
    private String createUser;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;


}
