package com.rocogz.syy.equity;

/**
 * <dl>
 * <dd>Description: 权益常量类 Service</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-10 17:35:43</dd>
 * <dd>@author：Andy</dd>
 * <description>
 * 1：Andy 2020-08-14 09:54:05 将重复的值提取为COMMON_FLAG前缀，不同变量名称相同值的其他常量值在运行稳定后会删除
 * 2:
 * </description>
 * </dl>
 */
public final class EquityConstants {

	public static final Long REDIS_KEY_TIME_OUT = 600L;

	/** 180天常量 **/
	public static final String HALF_YEAR_DAYS = "180";

	/** 365天常量 **/
	public static final String YEAR_DAYS = "365";

	/** 30天常量 **/
	public static final String MONTH_DAYS = "30";

	/** 0天常量 **/
	public static final String COMMON_ZERO = "0";

	/** 批量短信发送锁后缀 **/
	public static final String BATCH_SEND_MESSAGE_LOCK_SUFFIX = "S";

	public static final String EMPTY_MESSAGE = "不能为空";

	/** 默认发放主体编号 **/
	public static final String DEFAULT_INSSBODY = "EI9999999999999";

	/** 优惠券不限张数 **/
	public static final Integer COUPON_UNLIMIT_QUANTITY = 999_999_999;

	/** 一键领券输入错误车牌的返回码 **/
	public static final String RECEIVE_EMPTY_USER_COUPON_CODE = "900000";

	/** 数据库字段**/
	public static final String CREATE_TIME_COLUMN = "create_time";

	/** sql日期函数中日期格式**/
	public static final String SQL_DATE_ICON = "'%Y-%m-%d'";

	public static final String SQL_DATE_FUNCTION = "date_format(%s, %s)";

	/** 数据库日期函数大于等于 **/
	public static final String SQL_DATE_FUNCTION_START = SQL_DATE_FUNCTION + " >= {0}";

	/** 数据库日期函数小于等于 **/
	public static final String SQL_DATE_FUNCTION_END = SQL_DATE_FUNCTION + " <= {0}";

	/** 批量插入行数 **/
	public static final Integer BATCH_INSERT_ROW = 3000;

	/** 次数的默认值:0（用户券使用次数、重试次数**/
	public static final Integer DEFAULT_QUANTITY_ZERO = 0;

	/** 用户券次数-总次数、可用次数**/
	public static final Integer USER_COUPON_TOTAL_AND_AVAILABLE_QUANTITY = 1;

	/** 油卡系统操作用户标识 **/
	public static final String OIL_SYSTEM_USER = "system";

	/** ROCO车服操作用户标识 **/
	public static final String ROCO_SYSTEM_USER = "admin";

	/** 油卡用户券 **/
	public static final String OIL_USER_COUPON = "OIL_USER_COUPON";

	/** 服务券 **/
	public static final String SERVICE_COUPON = "SERVICE";

	/** 加油代金券 **/
	public static final String OIL_CASH_COUPON = "OIL_CASH";

	/** 电子兑换券 **/
	public static final String OIL_CARD_COUPON = "OIL_CARD";

	/** 代驾券 **/
	public static final String DRIVING_SERVICE_COUPON = "DRIVING_SERVICE";

	/** 电子油卡券 **/
	public static final String OIL_CARD_DIGITAL_COUPON = "OIL_CARD_DIGITAL";

	/** 电子油卡券直充 **/
	public static final String OIL_CARD_DIGITAL_YES_COUPON = "OIL_CARD_DIGITAL_YES";

	/** 积分券 **/
	public static final String POINT_COUPON = "POINT";

	/** 套餐券 **/
	public static final String PACKAGE_COUPON = "PACKAGE";

	/**
	 * 产品性质: 单品
	 */
	public final static String GOODS_NATURE_ITEM = "ITEM";
	/**
	 * 产品性质: 供应商定制套餐
	 */
	public final static String GOODS_NATURE_SUPPLIER_MEAL = "SUPPLIER_MEAL";
	/**
	 * 产品性质: 平台定制套餐
	 */
	public final static String GOODS_NATURE_PLATFORM_MEAL = "PLATFORM_MEAL";



	/** 兑换券相关标志:服务券 **/
	public static final String EXCHANGE_COUPON_FLAG = "E";

	/** 代金券相关标志：代金券、代驾券**/
	public static final String CASH_COUPON_FLAG = "C";

	/** 公共标志:否 **/
	public static final String COMMON_FLAG_N = "N";

	/** 公共标志:是 **/
	public static final String COMMON_FLAG_Y = "Y";

	/** 公共标志：失败 **/
	public static final String COMMON_FLAG_FAIL = "FAIL";

	/** 公共标志：已使用 **/
	public static final String COMMON_FLAG_USED = "USED";

	/** 公共标志：已处理/已通知**/
	public static final String COMMON_FLAG_PROCESS = "PROCESS";

	/** 公共标志：草稿/初始 **/
	public static final String COMMON_FLAG_DRAFT = "DRAFT";

	/** 公共标志：新增/创建**/
	public static final String COMMON_FLAG_ADD = "ADD";

	/** 公共标志：减少**/
	public static final String COMMON_FLAG_SUBTRACT = "SUBTRACT";

	/** 公共标志：取消/作废/注销 **/
	public static final String COMMON_FLAG_CANCEL = "CANCEL";

	/** 公共标志：作废中**/
	public static final String COMMON_FLAG_IN_CANCEL = "IN_CANCEL";

	/** 公共标志：作废失败**/
	public static final String COMMON_FLAG_CANCEL_FAIL = "CANCEL_FAIL";

	/** 公共标志：撤回 **/
	public static final String COMMON_FLAG_RECALL = "RECALL";

	/** 公共标志：冻结 **/
	public static final String COMMON_FLAG_FROZEN = "FROZEN";

	/** 公共标志：已过期/已失效 **/
	public static final String COMMON_FLAG_INVALID = "INVALID";

	/** 公共标志：启用 **/
	public static final String COMMON_FLAG_OPEN = "OPEN";

	/** 公共标志：停用 **/
	public static final String COMMON_FLAG_LOCK = "LOCK";

	/** 公共标志：转赠中 **/
	public static final String COMMON_FLAG_TRANSFER = "TRANSFER";

	/** 公共标志：其他 **/
	public static final String COMMON_FLAG_OTHER = "OTHER";

	/** 公共标志：编辑 **/
	public static final String COMMON_FLAG_EDIT = "EDIT";

	/** 公共标志：数量规则 **/
	public static final String COMMON_FLAG_QUANTITY_RULE = "QUANTITY_RULE";

	/** 公共标志：金额规则 **/
	public static final String COMMON_FLAG_AMOUNT_RULE = "AMOUNT_RULE";

	/** 公共标志:待审核**/
	public static final String COMMON_FLAG_APPROVE = "APPROVE";

	/** 公共标志：外部、外呼等 **/
	public static final String COMMON_FLAG_OUT = "OUT";

	/**	公共标志：上午 **/
	public static final String COMMON_FLAG_AM = "AM";

	/** 公共标志：下午 **/
	public static final String COMMON_FLAG_PM = "PM";

	/**	公共标志：晚上 **/
	public static final String COMMON_FLAG_NIGHT = "NIGHT";

	/**	公共标志：默认1次 **/
	public static final Integer COMMON_FLAG_DEFAULT_ONE = 1;

	/**	公共标志：审批后待发放 **/
//	public static final String COMMON_APPROVE_INIT = "APPROVE_INIT";

	/** 即将过期 **/
	public static final String WILL_EXPIRE = "WILL_EXPIRE";

	/** 全部：代表优惠券状态全部，所有门店可用，所有专区可用等等 **/
	public static final String STATUS_ALL = "ALL";

	/** 优惠券状态-上架**/
	public static final String COUPON_STATUS_TO_LIST = "TO_LIST";

	/** 优惠券状态-草稿**/
	public static final String COUPON_STATUS_DRAFT = "DRAFT";

	/** 申请单状态-申请单提交中**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_IN_SUBMIT = "IN_SUBMIT";

	/** 申请单状态-处理中**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_IN_PROCESS = "IN_PROCESS";

	/** 申请单状态-待处理**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_PENDING = "PENDING";

	/** 申请单状态-不通过**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_DISAGREE = "DISAGREE";

	/** 申请单状态-审核不通过**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_APPROVE_DISAGREE = "APPROVE_DISAGREE";

	/** 申请单状态-再次处理**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_AGAIN = "AGAIN";

	/** 申请单状态-部分失败**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_SOME_FAIL = "SOME_FAIL";

	/** 申请单状态-异常**/
	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_ABNORMAL = "ABNORMAL";

	/** 申请单清单状态-初始**/
	public static final String BATCH_DISTRIBUTION_APPLY_DETAIL_STATUS_INIT = "INIT";

	/** 申请单清单状态-初始-待审批**/
	public static final String BATCH_DISTRIBUTION_APPLY_DETAIL_STATUS_INIT_APPROVE = "INIT_APPROVE";

	/** 申请单清单状态-初始-失败**/
	public static final String BATCH_DISTRIBUTION_APPLY_DETAIL_STATUS_INIT_FAIL = "INIT_FAIL";

	/** 申请单清单状态-初始-失败-待审批**/
	public static final String BATCH_DISTRIBUTION_APPLY_DETAIL_STATUS_INIT_FAIL_APPROVE = "INIT_FAIL_APPROVE";

	/** 申请单公共状态-成功**/
	public static final String BATCH_DISTRIBUTION_COMMON_STATUS_SUCCESS = "SUCCESS";

	/** 申请单日期状态-已通过 **/
	public static final String BATCH_DISTRIBUTION_LOG_STATUS_PASS = "PASS";

	/** 优惠券投放信息中公共日期模式-领取既（生效/失效） **/
	public static final String COUPON_LAUNCH_INFO_DATE_NOW = "NOW";

	/** 优惠券投放信息中公共日期模式-领取后XX天（生效/失效） **/
	public static final String COUPON_LAUNCH_INFO_DATE_MODEL_LAST_DAY = "LAST_DAY";

	/** 优惠券投放信息中公共日期模式-指定日期（生效/失效） **/
	public static final String COUPON_LAUNCH_INFO_DATE_MODEL_POINT_DATE = "POINT_DATE";

	/** 优惠券投放信息中公共日期模式-根据保单有效期计算（生效/失效） **/
	public static final String COUPON_LAUNCH_INFO_DATE_MODEL_POLICY_DATE = "POLICY_DATE";

	/** 优惠券投放信息中订单失效-与优惠券失效日期相同 **/
	public static final String COUPON_LAUNCH_INFO_COUPON_INVALID = "COUPON_INVALID";

	/** 优惠券投放信息中订单失效-优惠券失效后XX天（失效） **/
	public static final String COUPON_LAUNCH_INFO_COUPON_LAST_DAY_INVALID = "COUPON_LAST_DAY_INVALID";

	/** 用户券状态-去兑换标志 **/
	public static final String USER_COUPON_STATUS_EXCHANGE = "EXCHANGE";

	/** 用户券状态-未生效 **/
	public static final String USER_COUPON_STATUS_UN_EFFECTIVE = "UN_EFFECTIVE";

	/** 用户券状态-正常/待使用 **/
	public static final String USER_COUPON_STATUS_NORMAL = "NORMAL";

	/** 用户券发放模式-批量发放 **/
	public static final String USER_COUPON_GRANT_MODEL_BATCH = "BATCH";

	/** 用户券发放模式-会员领取 **/
	public static final String USER_COUPON_GRANT_MODEL_RECEIVE = "RECEIVE";

	/** 用户券发放模式-接口发放 **/
	public static final String USER_COUPON_GRANT_MODEL_INTERFACE = "INTERFACE";

	/** 用户券发放模式-投保礼发放 **/
	public static final String USER_COUPON_GRANT_MODEL_INSURANCE_GIFT = "INSURANCE_GIFT";

	/** 用户券发放模式-客户兑换 **/
	public static final String USER_COUPON_GRANT_MODEL_CUSTOMER_EXCHANGE = "EXCHANGE";

	/** 用户券发放模式-手工发放 **/
	public static final String USER_COUPON_GRANT_MODEL_MANUAL = "MANUAL";

	/** 用户券操作日志-调整有效期 **/
	public static final String USER_COUPON_OPERATE_LOG_CHANGEDATE = "CHANGEDATE";

	/** 用户券操作日志-退还 **/
	public static final String USER_COUPON_OPERATE_LOG_RETURN = "RETURN";

	/** 用户券发券性质-字典类型 **/
	public static final String USER_COUPON_NATURE_TYPE_CODE = "USER_COUPON_NATURE";

	/** 用户券发放性质-业务验证 **/
	public static final String USER_COUPON_NATURE_BUSINESS_VERIFY = "BUSINESS_VERIFY";

	/** 平台（投放平台/使用平台）-SYY **/
	public static final String PLATFORM_CODE_SYY = "SYY";

	/** 平台（投放平台/使用平台）-SCM(供应链） **/
	public static final String PLATFORM_CODE_SCM = "SCM";

	/** 平台（投放平台/使用平台）-OIL(油卡） **/
	public static final String PLATFORM_CODE_OIL = "OIL";

	/** 平台（投放平台/使用平台）-SupplyChain **/
	public static final String PALTFORM_CODE_SUPPLYCHAIN = "SupplyChain";

	/** 用户券使用方式：SYSTEM-系统（前端正常使用）,MANUAL-后台手工补消耗 **/
	public static final String USER_COUPON_USE_WAY_SYSTEM = "SYSTEM";

	/** 油卡请求发券状态及回调状态-初始,此状态标识券未发放成功 **/
	public static final String OIL_CARD_STATUS_INIT = "INIT";

	/** 油卡请求操作类型-退回 **/
	public static final String OIL_CARD_REQUEST_OPERATE_TYPE_BACK = "BACK";

	/** 通知油卡结果状态-异常 **/
	public static final String CALL_OIL_CARD_RESULT_STATUS_ABNORMAL = "ABNORMAL";

	/** 油卡用户券状态-充值中 **/
	public static final String OIL_CARD_USER_COUPON_IN_EXCHANGE = "IN_EXCHANGE";

	/** MQ 相关 **/
	/** 权益服务公共MQ交换器 **/
	public static final String EQUITY_MQ_COMMON_EXCHANGES = "EQUITY_COMMON_EXCHANGES";

	/** 权益服务-主体客户关系数据-交换器  **/
	public static final String USER_EXCHANGE = "USER_EXCHANGE";

	/** 权益服务-油卡发券-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_OIL_CARD_USER_COUPON = "EQUITY_OIL_CARD_USER_COUPON";

	/** 权益服务-发券结果通知-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_OIL_CARD_RESULT_CALL = "EQUITY_OIL_CARD_RESULT_CALL";

	/** 权益服务-领取结果通知-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_RECEIVE_RESULT_CALL = "EQUITY_OIL_CARD_RECEIVE_RESULT_CALL";

	/** 权益服务-充值-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_OIL_CARD_EXCHANGE = "EQUITY_OIL_CARD_EXCHANGE";

	/** 权益服务-充值结果-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_OIL_CARD_EXCHANGE_RESULT = "EQUITY_OIL_CARD_EXCHANGE_RESULT";

	/** 权益服务-更新优惠券发放数量-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_UPDATE_COUPON_GRANT_NUMBER = "EQUITY_UPDATE_COUPON_GRANT_NUMBER";

	/** 权益服务-发放用户券后给客户发送系统消息-路由及队列 **/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_GRANT_COUPON_SEND_MESSAGE = "EQUITY_GRANT_COUPON_SEND_MESSAGE";

	/** 权益服务-主体客户关系数据-队列 **/
	public static final String USER_ISSUING_BODY_CUSTOMER_QUEUE = "USER_ISSUING_BODY_CUSTOMER_QUEUE";

	/**	权益服务-调用第三方接口-路由及队列**/
	public static final String EQUITY_MQ_ROUTEKEY_QUEUE_REMOTE_THIRD = "EQUITY_REMOTE_THIRD";

	/**	权益服务-权益领取-路由及队列**/
	public static final String EQUITY_MQ_ROUTKEY_QUEUE_RECEIVE_USER_COUPON = "EQUITY_RECEIVE";

	/** 权益服务-权益使用-路由及队列**/
	public static final String EQUITY_MQ_ROUTKEY_QUEUE_USER_COUPON_CONSUME = "USER_COUPON_CONSUME_QUEUE";

	/** 服务券消耗锁key **/
	public static final String COUPON_CONSUME_LOCK_KEY_SERVICE = "SERVICE_";

	/** 代金券消耗锁key **/
	public static final String COUPON_CONSUME_LOCK_KEY_OILCASH = "OILCASH_";

	/** 电子兑换券名称 **/
	public static final String OIL_CARD_COUPON_NAME = "电子兑换券";

	/**	数据字典类型：积分类型 **/
	public static final String DICT_TYPE_CODE_POINT_TYPE = "POINT_TYPE";

	/**	积分账户类型：大诚积分 **/
	public static final String POINT_ACCOUNT_TYPE_ROCO = "ROCO_POINT";

	/**	积分账户类型：代理人积分 **/
	public static final String POINT_ACCOUNT_TYPE_AGENT = "ROCO_AGENT_POINT";

	/**	积分账户类型：通用兑换积分 **/
	public static final String POINT_ACCOUNT_TYPE_COMMON_EXCHANGE = "COMMON_EXCHANGE_POINT";

	/** 积分账户类型：专项积分 **/
	public static final String POINT_ACCOUNT_TYPE_WITHDRAWALS_POINT = "WITHDRAWALS_POINT";

	/**	可用专区：指定专区 **/
	public static final String AVAILABLE_AREA_POINT_AREA ="POINT_AREA";

	/**	可用门店：指定门店 **/
	public static final String AVAILABLE_STORE_POINT_STORE ="POINT_STORE";

	/** 积分发放字典类型 **/
	public static final String DICT_TYPE_CODE_POINT_GRANT_TYPE = "POINT_GRANT_TYPE";
	/** 积分发放类型-普通发放 **/
	public static final String POINT_GRANT_TYPE_NORMAL = "NORMAL";
	/** 积分发放类型-个人订单 **/
	public static final String POINT_GRANT_TYPE_PERSON_ORDER = "PERSON_ORDER";
	/** 积分发放类型-团队订单 **/
	public static final String POINT_GRANT_TYPE_TEAM_ORDER = "TEAM_ORDER";
	/** 积分发放类型-转赠发放 **/
	public static final String POINT_GRANT_TYPE_TRANSFER = "TRANSFER";
	/** 积分发放类型-认证奖励 **/
	public static final String POINT_GRANT_TYPE_AUTHENTICATION = "AUTHENTICATION";
	/** 积分发放类型-注册奖励 **/
	public static final String POINT_GRANT_TYPE_REGISTER = "REGISTER";

	public static final String DETAIL_TOTAL_ROW_KEY = "detailTotalRow";

	/** 到账通知 字典类型 **/
	public static final String SMS_ACCOUNT_NOTICE_DICT_TYPE_CODE = "SMS_ACCOUNT_NOTICE";
	/** 到账通知 模板参数 **/
	public static final String SMS_ACCOUNT_NOTICE_PARAM_GIFT_NAME = "giftName";
	/** 到账通知 模板参数 **/
	public static final String SMS_ACCOUNT_NOTICE_PARAM_PHONE = "phone";
	/** 到账通知 模板参数 **/
	public static final String SMS_ACCOUNT_NOTICE_PARAM_FACEVALUE = "faceValue";
	/** 截止日期 模板参数**/
	public static final String SMS_ACCOUNT_NOTICE_PARAM_INVALID_DATE = "invalidDate";

	/** 日志类型：申请单 **/
	public static final String OPERATE_LOG_TYPE_APPLY = "APPLY";

	/** 日志类型：赠送订单 **/
	public static final String OPERATE_LOG_TYPE_GIFT = "GIFT";

	/** 日志操作：调整发券性质 **/
	public static final String OPERATE_LOG_OPERATION_ADJUSTMENT_NATURE = "ADJUSTMENT_NATURE";

	/** 领取验证规则：手机号前N位 **/
	public static final String RECEIVE_RULE_MOBILE_BEFORE_N = "MOBILE_BEFORE_N";

	/** 领取验证规则：手机号后N位 **/
	public static final String RECEIVE_RULE_MOBILE_AFTER_N = "MOBILE_AFTER_N";

	/** 领取验证规则：车牌号后N位 **/
	public static final String RECEIVE_RULE_CARNUMBER_AFTER_N = "CARNUMBER_AFTER_N";

	/** 领取验证规则：姓名 **/
	public static final String RECEIVE_RULE_NAME = "NAME";
	/**	查询SQL **/
	public static final String SEARCH_SQL_KEY = "searchSql";
	/**	参数key **/
	public static final String PARAM_KEY = "paramKey";

	/** 供应链订单类型：活动赠送 **/
	public static final String SCM_ORDER_TYPE_ACTIVITY_GIFT = "ACTIVITY_GIFT";

	/** 动态上传excel模板对应列 **/
	public static class TemplateColumn {
		/** 模板列-手机号 */
		public static final String MOBILE_COLUMN = "MOBILE";
		/** 模板列-证件类型 */
		public static final String ID_TYPE_COLUMN = "IDTYPE";
		/** 模板列-证件号码 */
		public static final String ID_CARD_COLUMN = "IDCARD";
		/** 模板列-权益编号 */
		public static final String EQUITY_CODE_COLUMN = "EQUITYCODE";
		/** 模板列-权益名称 */
		public static final String EQUITY_NAME_COLUMN = "EQUITYNAME";
		/** 模板列-生效日期 */
		public static final String EFFECTIVE_DATE_COLUMN = "EFFECTIVEDATE";
		/** 模板列-失效日期 */
		public static final String INVALID_DATE_COLUMN = "INVALIDDATE";
		/** 模板列-车牌号 */
		public static final String LICENSE_NO_COLUMN = "LICENSENO";
		/** 模板列-车架号 */
		public static final String VIN_NO_COLUMN = "VINNO";
		/** 模板列-主体发券类型 */
		public static final String GRANT_COUPON_TYPE_COLUMN = "GRANTCOUPONTYPE";
		/** 模板列-保单号 */
		public static final String POLICY_NO_COLUMN = "POLICYNO";
		/** 模板列-姓名 */
		public static final String NAME_COLUMN = "NAME";
		/** 模板列-发放张数 */
		public static final String QUANTITY_COLUMN = "QUANTITY";
		/** 模板列-油卡金额 */
		public static final String AMOUNT_COLUMN = "AMOUNT";
		/** 模板列-注释 */
		public static final String NOTES_COLUMN = "NOTES";
		/** 模板列-品牌 */
		public static final String BRAND_COLUMN = "BRAND";

	}

	// 待删除的常量 Andy 2020-08-14 10:44:06
//	/** 用户券显示标志-Y显示 **/
//	public static final String USER_COUPON_SHOW_FLAG = "Y";
//	/** 失败 **/
//	public static final String OIL_CARD_RESULT_STATUS_FAIL = "FAIL";
//	/** 申请单公共状态-失败**/
//	public static final String BATCH_DISTRIBUTION_COMMON_STATUS_FAIL = "FAIL";
//	/** 通知油卡结果状态-通知失败 **/
//	public static final String CALL_OIL_CARD_RESULT_STATUS_FAIL = "FAIL";
//	/** 已使用/已消耗 **/
//	public static final String USER_COUPON_STATUS_USED = "USED";
//	/** 油卡用户券状态-已兑换（已使用） **/
//	public static final String OIL_CARD_USER_COUPON_STATUS_USED = "USED";
//	/** 申请单状态-已处理**/
//	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_PROCESS = "PROCESS";
//	/** 通知油卡结果状态-已通知 **/
//	public static final String CALL_OIL_CARD_RESULT_STATUS_PROCESS = "PROCESS";
//	/** 新增/创建 **/
//	public static final String OIL_CARD_REQUEST_OPERATE_TYPE_ADD = "ADD";
//	/** 申请单状态-作废**/
//	public static final String BATCH_DISTRIBUTION_APPLY_STATUS_CANCEL = "CANCEL";
//	/** 已作废/已取消 **/
//	public static final String USER_COUPON_STATUS_CANCEL = "CANCEL";
//	/** 油卡请求操作类型-作废 **/
//	public static final String OIL_CARD_REQUEST_OPERATE_TYPE_CANCEL = "CANCEL";
//	/** 已冻结 **/
//	public static final String USER_COUPON_STATUS_FROZEN = "FROZEN";
//	/** 已过期/失效 **/
//	public static final String USER_COUPON_STATUS_INVALID = "INVALID";
//	/** 优惠券类型状态-启用 **/
//	public static final String COUPON_TYPE_STATUS_OPEN = "OPEN";


    //huhl添加为了数据权限管理时获取到发放主体所有记录时，根据equity_issuing_body 中type进行分组，所以如果添加新的类型时最好是也要通知我
    /**
     * 发放主体类型字典类型
     */
    public static final String ISSUING_BODY_TYPE = "ISSUING_BODY_TYPE";

	/** 发放主体性质字典类型 **/
	public static final String ISSUING_BODY_NATURE = "ISSUING_BODY_NATURE";

    /**
     * 发放主体-发放机构
     */
    public static final String EQUITY_ISSUING_BODY_TYPE_ROCO_ORG = "ROCO_ORG";
    /**
     * 发放主体-平台商户
     */
    public static final String EQUITY_ISSUING_BODY_TYPE_BUSINESS = "BUSINESS";
    /**
     * 发放主体-合作企业
     */
    public static final String EQUITY_ISSUING_BODY_TYPE_ENTERPRISE = "ENTERPRISE";

    /**
     * 一级主体的父级编码.
     */
    public static final String FIRST_LEVEL_ISSUINGBODY_PARENT_CODE = "0";


    /**
     * 日志操作类型-创建
     */
    public static final String LOG_ADD_LABEL = "创建";
    /**
     * 日志操作类型-创建
     */
    public static final String LOG_EDIT_LABEL = "编辑";

    /**
     * 规则-生效方式，立即生效
     */
    public static final String RULE_EFFECTIVE_TYPE_NOW = "NOW";

    /**
     * 规则-生效方式，领取XX天后生效
     */
    public static final String RULE_EFFECTIVE_TYPE_LAST_DAY = "LAST_DAY";

    /**
     * 规则-是否需要验证-不需要
     */
    public static final String RULE_VERIFY_TYPE_N = "N";
    /**
     * 规则-是否需要验证-需要
     */
    public static final String RULE_VERIFY_TYPE_Y = "Y";

    /**
     * 领取验证规则-字典类型
     */
    public static final String DICT_RULE_CODE = "RECEIVE_RULES";

    /**
     * 发券模板通用模板code
     */
    public static final String EQUITY_TEMPLATE_COMMON_CODE = "ITCOMMON01";

    /**
     * 发券模板类型-通用
     */
    public static final String EQUITY_TEMPLATE_COMMON = "COMMON";
    /**
     * 发券模板类型-定制
     */
    public static final String EQUITY_TEMPLATE_CUSTOM = "CUSTOM";


	/**
	 * 发券模版管理中-模版列-自定义字典的 ColumnCode
	 */
	public static final String GRANT_COUPON_TYPE="GRANTCOUPONTYPE";
	/**
	 * 主要用在发券模版字典中 组装为系统Code,但GRANT_COUPON_TYPE太长了，使用这个短的表示
	 */
	public static final String GRANT_COUPON_TYPE_SHORT="GRANT";
	//名称
	public static final String GRANT_COUPON_TYPE_NAME="发券类型";

    /**
     * 转赠记录的状态
     */
    public static class BestowRecordStatus {
        public static final String TYPE_CODE = "BESTOW_STATUS";
        /**
         * 待支付
         */
        public static final String PENDING_PAY = "PENDING_PAY";
        /**
         * 待领取
         */
        public static final String UN_RECEIVE = "UN_RECEIVE";
        /**
         * 已领取
         */
        public static final String RECEIVED = "RECEIVED";
        /**
         * 已撤回
         */
        public static final String REVERT = "REVERT";
        /**
         * 已拒绝
         */
        public static final String REFUSE = "REFUSE";
        /**
         * 过期未领取
         */
        public static final String RECEIVE_TIME_OUT = "RECEIVE_TIME_OUT";
        /**
         * 已取消
         */
        public static final String CANCEL = "CANCEL";
    }

    /**
     * 转赠记录的物品的类型
     */
    public static class BestowRecordType {
        public static final String TYPE_CODE = "BESTOW_TYPE";
        /**
         * 用户券转赠
         */
        public static final String USER_COUPON = "USER_COUPON";
        /**
         * 服务券
         */
        public static final String SERVICE_COUPON = "SERVICE_COUPON";
        /**
         * 商户服务项目
         */
        public static final String STORE_SERVICE = "STORE_SERVICE";
        /**
         * 代金券
         */
        public static final String CASH_COUPON = "CASH_COUPON";
        /**
         * 代驾券
         */
        public static final String DESIGNATED_DRIVING_COUPON = "DESIGNATED_DRIVING_COUPON";
        /**
         * 套餐券
         */
        public static final String PACKAGE_COUPON = "PACKAGE_COUPON";
        /**
         * 积分
         */
        public static final String POINT = "POINT";
        /**
         * 商品
         */
        public static final String GOODS = "GOODS";
        /**
         * 套餐
         */
        public static final String MIX = "MIX";
    }

    /**
     * 转赠-业务类型
     */
    public static class BestowRecordServiceType {
        public static final String TYPE_CODE = "BESTOW_SERVICE_TYPE";
        /**
         * 车主端用户-转赠
         */
        public static final String CAR_OWNER_USER_BESTOW = "CAR_OWNER_USER_BESTOW";
        /**
         * 车主端代理人投保礼赠送
         */
        public static final String CAR_OWNER_AGENT_USER_INSURANCE_GIFT = "CAR_OWNER_AGENT_USER_INSURANCE_GIFT";
        /**
         * B端代理人投保礼赠送
         */
        public static final String B_AGENT_USER_INSURANCE_GIFT = "B_AGENT_USER_INSURANCE_GIFT";
        /**
         * 车主端用户-发券
         */
        public static final String CAR_OWNER_USER_GRANT_COUPON = "CAR_OWNER_USER_GRANT_COUPON";
        /**
         * 商户端用户投保礼赠送
         */
        public static final String STORE_USER_INSURANCE_GIFT = "STORE_USER_INSURANCE_GIFT";
        /**
         * 商户端用户-发券
         */
        public static final String STORE_USER_GRANT_COUPON = "STORE_USER_GRANT_COUPON";
    }

    /**
     * 转赠记录编码放号器
     */
    public static final String BESTOW_RECORD_CODE_SEQ = "BESTOW_CODE";


    /**
     * =============> 下面是 转赠记录 支付超时 自动取消队列 rabbit mq 常量
     */
    public static final String EQUITY_BESTOW_EXCHANGE = "EQUITY_BESTOW_EXCHANGE";
    public static final String EQUITY_BESTOW_CASH_PAY_ROUTE_KEY = "BESTOW_CASH_PAY_ROUTE_KEY";
    /**
     * 所有需要现金支付的转赠记录都会到这个队列里去，消息过期时间30分钟，过期后回到下面的死信队列里
     */
    public static final String EQUITY_BESTOW_CASH_PAY_QUEUE = "EQUITY_BESTOW_CASH_PAY_QUEUE";
    public static final String EQUITY_BESTOW_CASH_PAY_TIME_OUT_ROUTE_KEY = "BESTOW_CASH_PAY_TIME_OUT_ROUTE_KEY";
    public static final String EQUITY_BESTOW_CASH_PAY_TIME_OUT_QUEUE = "EQUITY_BESTOW_CASH_PAY_TIME_OUT_QUEUE";

    private EquityConstants() {
    }

    /**
     * 产品发放模式
     */
    public static final String PRODUCT_DISTRIBUTION_MODE = "PRODUCT_DISTRIBUTION_MODE";
    /**
     * 审核通过后直接发放
     */
    public static final String AFTER_PASSING_DIRECT_DISTRIBUTION = "AFTER_PASSING_DIRECT_DISTRIBUTION";
    /**
     * 需要系统集中发放
     */
    public static final String SYSTEM_CENTRALIZED_DISTRIBUTION = "SYSTEM_CENTRALIZED_DISTRIBUTION";



    /**
     * 批量发券系统审核规则类型规则使用条件
     */
    public static class EquityBatchApplyLimitTypeRuleCondition {

        /**
         * 字典TYPE_CODE
         */
        public static final String TYPE_CODE = "EQUITY_BATCH_APPLY_LIMIT_TYPE_RULES_COND";
        /**
         * 手机号
         */
        public static final String MOBILE = "MOBILE";
        /**
         * 姓名
         */
        public static final String NAME = "NAME";
        /**
         * 车牌号后三位
         */
        public static final String LICENSE_NO_AFTER_THREE = "LICENSE_NO_AFTER_THREE";
    }

    /**
	 * 批量发券系统审核规则类型规则
	 */
	public static class EquityBatchApplyLimitTypeRule {

		/**
		 * 字典TYPE_CODE
		 */
		public static final String TYPE_CODE = "EQUITY_BATCH_APPLY_LIMIT_TYPE_RULES";
		/**
		 * 发放次数上限
		 */
		public static final String QUANTITY_RULE = "QUANTITY_RULE";
		/**
		 * 发放总金额上限
		 */
		public static final String AMOUNT_RULE = "AMOUNT_RULE";
	}



	/**
	 * 发放主体性质
	 */
	public static class DictEquityIssuingBodyNature {

		/** 代理商**/
		public static final String AGENT = "AGENT";

		/**合作客户**/
		public static final String CUSTOMER = "CUSTOMER";

		/**其它**/
		public static final String  OTHER= "OTHER";
	}


    /**
     * 发券申请单类型
     */
    public static class DictEquityApplyType {

        /**
         * 字典TYPE_CODE
         **/
        public static final String TYPE_CODE = "EQUITY_APPLY_TYPE";

        /**
         * 后台批量发放
         */
        public static final String BATCH = "BATCH";

        /**
         * B端小程序-礼赠
         */
        public static final String B_WEAPP_GTFT = "B_WEAPP_GIFT";

		/**
		 * B端小程序-自选
		 */
		public static final String B_WEAPP_SELF_BUY = "B_WEAPP_SELF_BUY";

		/**
		 * 后台批量生成兑换码领取
		 */
		public static final String EXCHANGE_RECEIVE = "EXCHANGE_RECEIVE";
    }



    /**
     * 发券申请单 支付模式
     */
    public static class DictEquityApplyPayMode {

        /**
         * 字典TYPE_CODE
         **/
        public static final String TYPE_CODE = "EQUITY_APPLY_PAY_MODE";

        /**
         * 纯现金支付
         */
        public static final String CASH = "CASH";

        /**
         * 纯额度支付
         */
        public static final String QUOTA = "QUOTA";


        /**
         * 现金+额度 混合支付
         */
        public static final String CASH_WITH_QUOTA = "CASH_WITH_QUOTA";
    }



    /**
     * 申请单支付记录中的 支付方式
     */
    public static class DictEquityApplyPayWay {
        //字典类型编号
        public static final String TYPE_CODE = "EQUITY_APPLY_PAYMENT_WAY";

        //=== 下面是字典值

        //方法主体 个人账户额度
        public static final String QUOTA = "QUOTA";

        //现金支付之 微信支付
        public static final String WEIXIN = "WEIXIN";

        //现金支付之 支付宝支付
        public static final String ALIPAY = "ALIPAY";
    }


    /**
     * 申请单的支付状态
     */
    public static class DictEquityApplyPayStatus {
        //字典类型编号
        public static final String TYPE_CODE = "EQUITY_APPLY_PAYMENT_STATUS";

        //=== 下面是字典值

        //未支付
        public static final String UN_PAY = "UNPAY";

        //部分支付
        public static final String PART_PAY = "PART_PAY";

        //支付完成
        public static final String PAIED = "PAIED";

    }


    /**
     * 发券申请单 整单状态
     */
    public static class DictEquityApplyOrderStatus {

        /**
         * 字典TYPE_CODE
         **/
        public static final String TYPE_CODE = "EQUITY_APPLY_ORDER_STATUS";

        /**
         * 待支付
         */
        public static final String PENDING_PAY = "PENDING_PAY";

        /**
         * 已支付
         */
        public static final String PAIED = "PAIED";

        /**
         * 已取消
         */
        public static final String CANCELED = "CANCELED";
    }


    /**
     * 发券申请单 额度冻结状态
     */
    public static class DictEquityApplyFrozenStatus {

		 /**
         * 字典TYPE_CODE
         **/
        public static final String TYPE_CODE = "EQUITY_APPLY_FROZEN_STATUS";

        /**
         * 冻结成功
         */
        public static final String FROZEN = "FROZEN";
		/**
		 * 已解冻,释放冻结的额度
		 */
		public static final String UNFREEZE = "UNFREEZE";

        /**
         * 冻结失败
         */
        public static final String FAIL = "FAIL";
    }

    /**
     * 业务性质分类字典数据
     */
    public static class BusinessNatureClassificationDict {

        /** 业务性质分类字典类型**/
        public static final String BUSINESS_NATURE_CLASSIFICATION = "BUSINESS_NATURE_CLASSIFICATION";

        /** 业务阵地**/
        public static final String BUSINESS_POSITION = "BUSINESS_POSITION";

        /**业务基点**/
        public static final String BUSINESS_BASIC_POINT = "BUSINESS_BASIC_POINT";

        /**其它**/
        public static final String  BUSINESS_OTHER= "BUSINESS_OTHER";
    }

    /**
     * 结算单位标记字典数据
     */
    public static class SettlementUnitMarkDict {
        /**结算单位标记字典类型**/
        public static final String  SETTLEMENT_UNIT_MARK= "SETTLEMENT_UNIT_MARK";

        /** 结算单位**/
        public static final String SETTLEMENT_UNIT = "SETTLEMENT_UNIT";

        /**非结算单位**/
        public static final String NOT_SETTLEMENT_UNIT = "NOT_SETTLEMENT_UNIT";
    }

	/**
	 * 审核结果
	 */
	public static class DictApproveResult{

		/**标记字典类型**/
		public static final String  TYPE_CODE= "EQUITY_APPROVE_RESULT";

		/** 审核通过**/
		public static final String PASS = "PASS";

		/**审核不通过**/
		public static final String  DISAGREE = "DISAGREE";

	}




	/**
	 * 清单-撤回申请单状态
	 */
	public static class DictEquityRecallApplyStatus {

		/**
		 * 字典TYPE_CODE
		 **/
		public static final String TYPE_CODE = "EQUITY_RECALL_APPLY_STATUS";

		/**
		 * 待审核
		 */
		public static final String PENDING_APPROVE = "PENDING_APPROVE";

		/**
		 * 审核不通过
		 */
		public static final String APPROVE_REFUSE = "APPROVE_REFUSE";

		/**
		 * 审核通过
		 */
		public static final String APPROVE_PASS = "APPROVE_PASS";

		/**
		 * 撤回中
		 */
		public static final String IN_RECALL = "IN_RECALL";

		/**
		 * 撤回失败
		 */
		public static final String RECALL_FAIL = "RECALL_FAIL";

		/**
		 * 已撤回
		 */
		public static final String RECALL_SUCCESS = "RECALL_SUCCESS";
	}



	/**
	 * Redis缓存键值
	 */
	public static class RedisKey {

		/*创建撤回申请单的锁**/
		public final static String RECALL_APPLY_CREATE_KEY_PREFIX = "RECALL_APPLY_CREATE:";
	}

	/**
	 * 登陆账号类型
	 */
	public static class LoginAccountType{
		public final static String SYSTEM_ACCOUNT = "system"; //系统账号
		public final static String SERVICE_ACCOUNT = "service"; //服务商账号
		public final static String PLATFORM_ACCOUNT = "platform"; //主体账号
		public final static String BIZ_ACCOUNT = "biz"; //集成商账号
	}
}
