package com.rocogz.syy.equity.dto.equity.userCoupon;

import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 用户券转赠领取 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-08-19 09:33:48</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class UserCouponTransferReceiveDto {

    /**
     * 兑换码
     */
    @NotNull(message = "兑换码" + EquityConstants.EMPTY_MESSAGE)
    private List<String> redeemCodeList;

    /**
     * 赠送人openId
     */
    @NotNull(message = "赠送人openId" + EquityConstants.EMPTY_MESSAGE)
    private String giverOpenId;

    /**
     * 手机号
     */
    @NotNull(message = "手机号" + EquityConstants.EMPTY_MESSAGE)
    private String mobile;

    /**
     * 用户号
     */
    private String userCode;

    /**
     * openId
     */
    private String openId;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码(明文）
     */
    private String idCardExplicit;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 承保机构
     */
    private String policyOrgCode;
}
