package com.rocogz.syy.equity.entity.rule;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import java.util.List;

import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 领取验证规则实体
 * </p>
 *
 * @author yifenrui
 * @since 2021-03-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "equity_receive_rule")
public class EquityReceiveRule extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编码
     */
    private String code;

    /**
     * 主体编码
     */
    private String issuingBodyCode;

    @TableField(exist = false)
    private String issuingBodyName;

    /**
     * 验证方式
     */
    private String verifyType;

    /**
     * 规则数量
     */
    private Integer ruleNum;

    /**
     * 规则名称+验证值
     */
    private String rulesNameValue;

    /**
     * 状态
     */
    private String status;


    /**
     * 规则明细
     */
    @TableField(exist = false)
    private List<EquityReceiveRuleDetails> equityReceiveRuleDetails;

    /**
     * 更改前的规则明细
     */
    @TableField(exist = false)
    private List<EquityReceiveRuleDetails> equityReceiveRuleDetailsBefore;

}
